/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsat.linear.DenseMatrix;
import jsat.linear.IndexValue;
import jsat.linear.Matrix;
import jsat.linear.Vec;
import jsat.utils.FakeExecutor;
import jsat.utils.SystemInfo;

public abstract class GenericMatrix
extends Matrix {
    private static final long serialVersionUID = -8173419025024676713L;
    protected static int NB2 = (int)Math.sqrt((double)SystemInfo.L2CacheSize / 16.0);

    protected abstract Matrix getMatrixOfSameType(int var1, int var2);

    @Override
    public void mutableAdd(double c, Matrix b) {
        if (!GenericMatrix.sameDimensions(this, b)) {
            throw new ArithmeticException("Matrix dimensions do not agree");
        }
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                this.increment(i, j, c * b.get(i, j));
            }
        }
    }

    @Override
    public void mutableAdd(final double c, final Matrix b, ExecutorService threadPool) {
        if (!GenericMatrix.sameDimensions(this, b)) {
            throw new ArithmeticException("Matrix dimensions do not agree");
        }
        final CountDownLatch latch = new CountDownLatch(SystemInfo.LogicalCores);
        int threadId = 0;
        while (threadId < SystemInfo.LogicalCores) {
            final int ID = threadId++;
            threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0 + ID; i < GenericMatrix.this.rows(); i += SystemInfo.LogicalCores) {
                        for (int j = 0; j < GenericMatrix.this.cols(); ++j) {
                            GenericMatrix.this.increment(i, j, c * b.get(i, j));
                        }
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DenseMatrix.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void mutableAdd(double c) {
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                this.increment(i, j, c);
            }
        }
    }

    @Override
    public void mutableAdd(final double c, ExecutorService threadPool) {
        final CountDownLatch latch = new CountDownLatch(SystemInfo.LogicalCores);
        int threadId = 0;
        while (threadId < SystemInfo.LogicalCores) {
            final int ID = threadId++;
            threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0 + ID; i < GenericMatrix.this.rows(); i += SystemInfo.LogicalCores) {
                        for (int j = 0; j < GenericMatrix.this.cols(); ++j) {
                            GenericMatrix.this.increment(i, j, c);
                        }
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DenseMatrix.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void multiply(Vec b, double z, Vec c) {
        if (this.cols() != b.length()) {
            throw new ArithmeticException("Matrix dimensions do not agree, [" + this.rows() + "," + this.cols() + "] x [" + b.length() + ",1]");
        }
        if (this.rows() != c.length()) {
            throw new ArithmeticException("Target vector dimension does not agree with matrix dimensions. Matrix has " + this.rows() + " rows but tagert has " + c.length());
        }
        if (b.isSparse()) {
            for (int i = 0; i < this.rows(); ++i) {
                double dot = 0.0;
                for (IndexValue iv : b) {
                    dot += this.get(i, iv.getIndex()) * iv.getValue();
                }
                c.increment(i, dot * z);
            }
        } else {
            for (int i = 0; i < this.rows(); ++i) {
                double dot = 0.0;
                for (int j = 0; j < this.cols(); ++j) {
                    dot += this.get(i, j) * b.get(j);
                }
                c.increment(i, dot * z);
            }
        }
    }

    @Override
    public void multiply(Matrix b, Matrix C) {
        if (!GenericMatrix.canMultiply(this, b)) {
            throw new ArithmeticException("Matrix dimensions do not agree: [" + this.rows() + ", " + this.cols() + "] * [" + b.rows() + ", " + b.cols() + "]");
        }
        if (this.rows() != C.rows() || b.cols() != C.cols()) {
            throw new ArithmeticException("Target Matrix is no the correct size");
        }
        for (int i = 0; i < C.rows(); ++i) {
            for (int k = 0; k < this.cols(); ++k) {
                double a = this.get(i, k);
                for (int j = 0; j < C.cols(); ++j) {
                    C.increment(i, j, a * b.get(k, j));
                }
            }
        }
    }

    @Override
    public void multiplyTranspose(Matrix b, Matrix C) {
        if (this.cols() != b.cols()) {
            throw new ArithmeticException("Matrix dimensions do not agree");
        }
        if (this.rows() != C.rows() || b.rows() != C.cols()) {
            throw new ArithmeticException("Target Matrix is no the correct size");
        }
        int iLimit = this.rows();
        int jLimit = b.rows();
        int kLimit = this.cols();
        for (int i0 = 0; i0 < iLimit; i0 += NB2) {
            for (int j0 = 0; j0 < jLimit; j0 += NB2) {
                for (int k0 = 0; k0 < kLimit; k0 += NB2) {
                    for (int i = i0; i < Math.min(i0 + NB2, iLimit); ++i) {
                        for (int j = j0; j < Math.min(j0 + NB2, jLimit); ++j) {
                            double C_ij = 0.0;
                            for (int k = k0; k < Math.min(k0 + NB2, kLimit); ++k) {
                                C_ij += this.get(i, k) * b.get(j, k);
                            }
                            C.increment(i, j, C_ij);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void multiplyTranspose(final Matrix b, final Matrix C, ExecutorService threadPool) {
        if (this.cols() != b.cols()) {
            throw new ArithmeticException("Matrix dimensions do not agree");
        }
        if (this.rows() != C.rows() || b.rows() != C.cols()) {
            throw new ArithmeticException("Destination matrix does not have matching dimensions");
        }
        final GenericMatrix A = this;
        final int iLimit = this.rows();
        final int jLimit = b.rows();
        final int kLimit = this.cols();
        final int blockStep = Math.min(NB2, Math.max(iLimit / SystemInfo.LogicalCores, 1));
        final CountDownLatch cdl = new CountDownLatch(SystemInfo.LogicalCores);
        int threadNum = 0;
        while (threadNum < SystemInfo.LogicalCores) {
            final int threadID = threadNum++;
            threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    for (int i0 = blockStep * threadID; i0 < iLimit; i0 += blockStep * SystemInfo.LogicalCores) {
                        for (int k0 = 0; k0 < kLimit; k0 += blockStep) {
                            for (int j0 = 0; j0 < jLimit; j0 += blockStep) {
                                for (int i = i0; i < Math.min(i0 + blockStep, iLimit); ++i) {
                                    for (int j = j0; j < Math.min(j0 + blockStep, jLimit); ++j) {
                                        double C_ij = 0.0;
                                        for (int k = k0; k < Math.min(k0 + blockStep, kLimit); ++k) {
                                            C_ij += A.get(i, k) * b.get(j, k);
                                        }
                                        C.increment(i, j, C_ij);
                                    }
                                }
                            }
                        }
                    }
                    cdl.countDown();
                }
            });
        }
        try {
            cdl.await();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DenseMatrix.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void multiply(final Matrix b, final Matrix C, ExecutorService threadPool) {
        if (!GenericMatrix.canMultiply(this, b)) {
            throw new ArithmeticException("Matrix dimensions do not agree");
        }
        if (this.rows() != C.rows() || b.cols() != C.cols()) {
            throw new ArithmeticException("Destination matrix does not match the multiplication dimensions");
        }
        final CountDownLatch cdl = new CountDownLatch(SystemInfo.LogicalCores);
        final GenericMatrix A = this;
        if (this.rows() / NB2 >= SystemInfo.LogicalCores) {
            final int kLimit = A.cols();
            final int jLimit = C.cols();
            final int iLimit = C.cols();
            int threadID = 0;
            while (threadID < SystemInfo.LogicalCores) {
                final int ID = threadID++;
                threadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i0 = NB2 * ID; i0 < iLimit; i0 += NB2 * SystemInfo.LogicalCores) {
                            for (int k0 = 0; k0 < kLimit; k0 += NB2) {
                                for (int j0 = 0; j0 < jLimit; j0 += NB2) {
                                    for (int i = i0; i < Math.min(i0 + NB2, iLimit); ++i) {
                                        for (int k = k0; k < Math.min(k0 + NB2, kLimit); ++k) {
                                            double a = A.get(i, k);
                                            for (int j = j0; j < Math.min(j0 + NB2, jLimit); ++j) {
                                                C.increment(i, j, a * b.get(k, j));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                });
            }
            return;
        }
        int threadID = 0;
        while (threadID < SystemInfo.LogicalCores) {
            final int ID = threadID++;
            threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0 + ID; i < C.rows(); i += SystemInfo.LogicalCores) {
                        for (int k = 0; k < A.cols(); ++k) {
                            double a = A.get(i, k);
                            for (int j = 0; j < C.cols(); ++j) {
                                C.increment(i, j, a * b.get(k, j));
                            }
                        }
                    }
                    cdl.countDown();
                }
            });
        }
        try {
            cdl.await();
        }
        catch (InterruptedException ex) {
            this.multiply(b, C);
        }
    }

    @Override
    public void mutableMultiply(double c) {
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                this.set(i, j, this.get(i, j) * c);
            }
        }
    }

    @Override
    public void mutableMultiply(final double c, ExecutorService threadPool) {
        final CountDownLatch latch = new CountDownLatch(SystemInfo.LogicalCores);
        int threadID = 0;
        while (threadID < SystemInfo.LogicalCores) {
            final int ID = threadID++;
            threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    for (int i = ID; i < GenericMatrix.this.rows(); i += SystemInfo.LogicalCores) {
                        for (int j = 0; j < GenericMatrix.this.cols(); ++j) {
                            GenericMatrix.this.set(i, j, GenericMatrix.this.get(i, j) * c);
                        }
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DenseMatrix.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void transposeMultiply(double c, Vec b, Vec x) {
        if (this.rows() != b.length()) {
            throw new ArithmeticException("Matrix dimensions do not agree, [" + this.cols() + "," + this.rows() + "] x [" + b.length() + ",1]");
        }
        if (this.cols() != x.length()) {
            throw new ArithmeticException("Matrix dimensions do not agree with target vector");
        }
        for (int i = 0; i < this.rows(); ++i) {
            double b_i = b.get(i);
            if (b_i == 0.0) continue;
            for (int j = 0; j < this.cols(); ++j) {
                x.increment(j, c * b_i * this.get(i, j));
            }
        }
    }

    @Override
    public void transposeMultiply(Matrix b, Matrix C) {
        this.transposeMultiply(b, C, new FakeExecutor());
    }

    @Override
    public void transposeMultiply(final Matrix b, final Matrix C, ExecutorService threadPool) {
        if (this.rows() != b.rows()) {
            throw new ArithmeticException("Matrix dimensions do not agree");
        }
        if (this.cols() != C.rows() || b.cols() != C.cols()) {
            throw new ArithmeticException("Destination matrix does not have matching dimensions");
        }
        final GenericMatrix A = this;
        final int iLimit = C.rows();
        final int jLimit = C.cols();
        final int kLimit = this.rows();
        final int blockStep = Math.min(NB2, Math.max(iLimit / SystemInfo.LogicalCores, 1));
        final CountDownLatch cdl = new CountDownLatch(SystemInfo.LogicalCores);
        int threadNum = 0;
        while (threadNum < SystemInfo.LogicalCores) {
            final int threadID = threadNum++;
            threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    for (int i0 = blockStep * threadID; i0 < iLimit; i0 += blockStep * SystemInfo.LogicalCores) {
                        for (int k0 = 0; k0 < kLimit; k0 += blockStep) {
                            for (int j0 = 0; j0 < jLimit; j0 += blockStep) {
                                for (int k = k0; k < Math.min(k0 + blockStep, kLimit); ++k) {
                                    for (int i = i0; i < Math.min(i0 + blockStep, iLimit); ++i) {
                                        double a = A.get(k, i);
                                        for (int j = j0; j < Math.min(j0 + blockStep, jLimit); ++j) {
                                            C.increment(i, j, a * b.get(k, j));
                                        }
                                    }
                                }
                            }
                        }
                    }
                    cdl.countDown();
                }
            });
        }
        try {
            cdl.await();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DenseMatrix.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void mutableTranspose() {
        if (!this.isSquare()) {
            throw new ArithmeticException("Can only mutable transpose square matrices");
        }
        for (int i = 0; i < this.rows() - 1; ++i) {
            for (int j = i + 1; j < this.cols(); ++j) {
                double tmp = this.get(j, i);
                this.set(j, i, this.get(i, j));
                this.set(i, j, tmp);
            }
        }
    }

    @Override
    public void transpose(Matrix C) {
        if (this.rows() != C.cols() || this.cols() != C.rows()) {
            throw new ArithmeticException("Target matrix does not have the correct dimensions");
        }
        for (int i0 = 0; i0 < this.rows(); i0 += NB2) {
            for (int j0 = 0; j0 < this.cols(); j0 += NB2) {
                for (int i = i0; i < Math.min(i0 + NB2, this.rows()); ++i) {
                    for (int j = j0; j < Math.min(j0 + NB2, this.cols()); ++j) {
                        C.set(j, i, this.get(i, j));
                    }
                }
            }
        }
    }

    @Override
    public void swapRows(int r1, int r2) {
        if (r1 >= this.rows() || r2 >= this.rows()) {
            throw new ArithmeticException("Can not swap row, matrix is smaller then requested");
        }
        if (r1 < 0 || r2 < 0) {
            throw new ArithmeticException("Can not swap row, there are no negative row indices");
        }
        for (int j = 0; j < this.cols(); ++j) {
            double tmp = this.get(r1, j);
            this.set(r1, j, this.get(r2, j));
            this.set(r2, j, tmp);
        }
    }

    @Override
    public void zeroOut() {
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                this.set(i, j, 0.0);
            }
        }
    }

    @Override
    public Matrix[] lup() {
        Matrix[] lup = new Matrix[3];
        DenseMatrix P = GenericMatrix.eye(this.rows());
        Matrix U = this;
        Matrix L = this.rows() > this.cols() ? this.getMatrixOfSameType(this.rows(), this.cols()) : this.getMatrixOfSameType(this.rows(), this.rows());
        for (int i = 0; i < U.rows(); ++i) {
            int j;
            if (i < U.cols()) {
                int largestRow = i;
                double largestVal = Math.abs(U.get(i, i));
                for (j = i + 1; j < U.rows(); ++j) {
                    double rowJLeadVal = Math.abs(U.get(j, i));
                    if (!(rowJLeadVal > largestVal)) continue;
                    largestRow = j;
                    largestVal = rowJLeadVal;
                }
                U.swapRows(largestRow, i);
                ((Matrix)P).swapRows(largestRow, i);
                L.swapRows(largestRow, i);
                L.set(i, i, 1.0);
            }
            for (int k = 0; k < Math.min(i, U.cols()); ++k) {
                double tmp = U.get(i, k) / U.get(k, k);
                L.set(i, k, Double.isNaN(tmp) ? 0.0 : tmp);
                U.set(i, k, 0.0);
                for (j = k + 1; j < U.cols(); ++j) {
                    U.increment(i, j, -L.get(i, k) * U.get(k, j));
                }
            }
        }
        if (this.rows() > this.cols()) {
            Matrix newU = this.getMatrixOfSameType(this.cols(), this.cols());
            for (int i = 0; i < this.cols(); ++i) {
                for (int j = 0; j < this.cols(); ++j) {
                    newU.set(i, j, U.get(i, j));
                }
            }
            U = newU;
        }
        lup[0] = L;
        lup[1] = U;
        lup[2] = P;
        return lup;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Matrix[] lup(ExecutorService threadPool) {
        Matrix[] lup = new Matrix[3];
        DenseMatrix P = GenericMatrix.eye(this.rows());
        Matrix U = this;
        GenericMatrix UU = U;
        DenseMatrix L = this.rows() > this.cols() ? new DenseMatrix(this.rows(), this.cols()) : new DenseMatrix(this.rows(), this.rows());
        try {
            int k;
            ArrayList<Future<Integer>> bigIndecies = new ArrayList<Future<Integer>>(SystemInfo.LogicalCores);
            for (k = 0; k < Math.min(this.rows(), this.cols()); ++k) {
                void var13_18;
                int largestRow = k;
                double largestVal = Math.abs(U.get(k, k));
                if (bigIndecies.isEmpty()) {
                    for (int j = k + 1; j < U.rows(); ++j) {
                        double d = Math.abs(U.get(j, k));
                        if (!(d > largestVal)) continue;
                        largestRow = j;
                        largestVal = d;
                    }
                } else {
                    for (Future future : bigIndecies) {
                        double rowJLeadVal;
                        int j = (Integer)future.get();
                        if (j < 0 || !((rowJLeadVal = Math.abs(U.get(j, k))) > largestVal)) continue;
                        largestRow = j;
                        largestVal = rowJLeadVal;
                    }
                    bigIndecies.clear();
                }
                U.swapRows(largestRow, k);
                ((Matrix)P).swapRows(largestRow, k);
                ((Matrix)L).swapRows(largestRow, k);
                ((Matrix)L).set(k, k, 1.0);
                final int kk = k;
                boolean bl = false;
                while (var13_18 < SystemInfo.LogicalCores) {
                    void threadID = var13_18++;
                    bigIndecies.add(threadPool.submit(new Callable<Integer>((int)threadID, (Matrix)UU, (Matrix)L){
                        final /* synthetic */ int val$threadID;
                        final /* synthetic */ Matrix val$UU;
                        final /* synthetic */ Matrix val$L;
                        {
                            this.val$threadID = n2;
                            this.val$UU = matrix;
                            this.val$L = matrix2;
                        }

                        @Override
                        public Integer call() throws Exception {
                            double largestSeen = 0.0;
                            int largestIndex = -1;
                            for (int i = kk + 1 + this.val$threadID; i < this.val$UU.rows(); i += SystemInfo.LogicalCores) {
                                double tmp = this.val$UU.get(i, kk) / this.val$UU.get(kk, kk);
                                this.val$L.set(i, kk, Double.isNaN(tmp) ? 0.0 : tmp);
                                this.val$UU.increment(i, kk + 1, -this.val$L.get(i, kk) * this.val$UU.get(kk, kk + 1));
                                if (Math.abs(this.val$UU.get(i, kk + 1)) > largestSeen) {
                                    largestSeen = Math.abs(this.val$UU.get(i, kk + 1));
                                    largestIndex = i;
                                }
                                for (int j = kk + 2; j < this.val$UU.cols(); ++j) {
                                    this.val$UU.increment(i, j, -this.val$L.get(i, kk) * this.val$UU.get(kk, j));
                                }
                            }
                            return largestIndex;
                        }
                    }));
                }
            }
            for (k = 0; k < Math.min(this.rows(), this.cols()); ++k) {
                for (int j = 0; j < k; ++j) {
                    U.set(k, j, 0.0);
                }
            }
            if (this.rows() > this.cols()) {
                Matrix newU = this.getMatrixOfSameType(this.cols(), this.cols());
                for (int i = 0; i < this.cols(); ++i) {
                    for (int j = 0; j < this.cols(); ++j) {
                        newU.set(i, j, U.get(i, j));
                    }
                }
                U = newU;
            }
            lup[0] = L;
            lup[1] = U;
            lup[2] = P;
            return lup;
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DenseMatrix.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DenseMatrix.class.getName()).log(Level.SEVERE, null, ex);
        }
        throw new RuntimeException("Uncrecoverable Error");
    }

    @Override
    public Matrix[] qr() {
        Matrix A;
        int N = this.cols();
        int M = this.rows();
        Matrix[] qr = new Matrix[2];
        DenseMatrix Q = Matrix.eye(M);
        if (this.isSquare()) {
            this.mutableTranspose();
            A = this;
        } else {
            A = this.transpose();
        }
        int to = this.cols() > this.rows() ? M : N;
        double[] vk = new double[M];
        for (int k = 0; k < to; ++k) {
            double vkNorm;
            double beta = vkNorm = this.initalVKNormCompute(k, M, vk, A);
            double vk_k = vk[k] = A.get(k, k);
            vkNorm += vk_k * vk_k;
            vkNorm = Math.sqrt(vkNorm);
            double alpha = -Math.signum(vk_k) * vkNorm;
            vk[k] = vk_k -= alpha;
            if ((beta += vk_k * vk_k) == 0.0) continue;
            double TwoOverBeta = 2.0 / beta;
            this.qrUpdateQ(Q, k, vk, TwoOverBeta);
            this.qrUpdateR(k, N, A, vk, TwoOverBeta, M);
        }
        qr[0] = Q;
        if (this.isSquare()) {
            A.mutableTranspose();
            qr[1] = A;
        } else {
            qr[1] = A.transpose();
        }
        return qr;
    }

    private void qrUpdateR(int k, int N, Matrix A, double[] vk, double TwoOverBeta, int M) {
        if (k < N) {
            this.qrUpdateRInitalLoop(k, A, vk, TwoOverBeta, M);
        }
        for (int j = k + 1; j < N; ++j) {
            int i;
            double y = 0.0;
            for (i = k; i < A.cols(); ++i) {
                y += vk[i] * A.get(j, i);
            }
            y *= TwoOverBeta;
            for (i = k; i < M; ++i) {
                A.increment(j, i, -y * vk[i]);
            }
        }
    }

    private void qrUpdateRInitalLoop(int k, Matrix A, double[] vk, double TwoOverBeta, int M) {
        int i;
        double y = 0.0;
        for (i = k; i < A.cols(); ++i) {
            y += vk[i] * A.get(k, i);
        }
        A.increment(k, k, -(y *= TwoOverBeta) * vk[k]);
        for (i = k + 1; i < M; ++i) {
            A.set(k, i, 0.0);
        }
    }

    private void qrUpdateQ(Matrix Q, int k, double[] vk, double TwoOverBeta) {
        for (int j = 0; j < Q.cols(); ++j) {
            int i;
            double y = 0.0;
            for (i = k; i < Q.cols(); ++i) {
                y += vk[i] * Q.get(j, i);
            }
            y *= TwoOverBeta;
            for (i = k; i < Q.rows(); ++i) {
                Q.increment(j, i, -y * vk[i]);
            }
        }
    }

    private double initalVKNormCompute(int k, int M, double[] vk, Matrix A) {
        double vkNorm = 0.0;
        for (int i = k + 1; i < M; ++i) {
            vk[i] = A.get(k, i);
            vkNorm += vk[i] * vk[i];
        }
        return vkNorm;
    }

    @Override
    public Matrix[] qr(ExecutorService threadPool) {
        Matrix A;
        final int N = this.cols();
        final int M = this.rows();
        Matrix[] qr = new Matrix[2];
        final DenseMatrix Q = Matrix.eye(M);
        if (this.isSquare()) {
            this.mutableTranspose();
            A = this;
        } else {
            A = this.transpose();
        }
        final double[] vk = new double[M];
        int to = this.cols() > this.rows() ? M : N;
        for (int k = 0; k < to; ++k) {
            double vkNorm;
            double beta = vkNorm = this.initalVKNormCompute(k, M, vk, A);
            double vk_k = vk[k] = A.get(k, k);
            vkNorm += vk_k * vk_k;
            vkNorm = Math.sqrt(vkNorm);
            double alpha = -Math.signum(vk_k) * vkNorm;
            vk[k] = vk_k;
            if ((beta += (vk_k -= alpha) * vk_k) == 0.0) continue;
            final double TwoOverBeta = 2.0 / beta;
            final CountDownLatch latch = new CountDownLatch(SystemInfo.LogicalCores);
            int ID = 0;
            while (ID < SystemInfo.LogicalCores) {
                final int threadID = ID++;
                final int kk = k;
                threadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        this.parallelQRUpdateQ();
                        this.parallelQRUpdateR();
                        latch.countDown();
                    }

                    private void parallelQRUpdateR() {
                        if (kk < N && threadID == 0) {
                            this.parallelQRUpdateRFirstIteration();
                        }
                        for (int j = kk + 1 + threadID; j < N; j += SystemInfo.LogicalCores) {
                            int i;
                            double y = 0.0;
                            for (i = kk; i < A.cols(); ++i) {
                                y += vk[i] * A.get(j, i);
                            }
                            y *= TwoOverBeta;
                            for (i = kk; i < M; ++i) {
                                A.increment(j, i, -y * vk[i]);
                            }
                        }
                    }

                    private void parallelQRUpdateRFirstIteration() {
                        int i;
                        double y = 0.0;
                        for (i = kk; i < A.cols(); ++i) {
                            y += vk[i] * A.get(kk, i);
                        }
                        A.increment(kk, kk, -(y *= TwoOverBeta) * vk[kk]);
                        for (i = kk + 1; i < M; ++i) {
                            A.set(kk, i, 0.0);
                        }
                    }

                    private void parallelQRUpdateQ() {
                        for (int j = 0 + threadID; j < Q.cols(); j += SystemInfo.LogicalCores) {
                            int i;
                            double y = 0.0;
                            for (i = kk; i < Q.cols(); ++i) {
                                y += vk[i] * Q.get(j, i);
                            }
                            y *= TwoOverBeta;
                            for (i = kk; i < Q.rows(); ++i) {
                                Q.increment(j, i, -y * vk[i]);
                            }
                        }
                    }
                });
            }
            try {
                latch.await();
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DenseMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        qr[0] = Q;
        if (this.isSquare()) {
            A.mutableTranspose();
            qr[1] = A;
        } else {
            qr[1] = A.transpose();
        }
        return qr;
    }

    @Override
    public Matrix clone() {
        Matrix clone = this.getMatrixOfSameType(this.rows(), this.cols());
        clone.mutableAdd(this);
        return clone;
    }
}

