/*
 * Decompiled with CFR 0.152.
 */
package jsat.guitool;

import javax.swing.table.AbstractTableModel;
import jsat.DataSet;

public class VecTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 876162850502819048L;
    private final int rows;
    private final int columns;
    private final DataSet dataSet;

    public VecTableModel(DataSet dataSet) {
        this.dataSet = dataSet;
        this.rows = dataSet.getSampleSize();
        this.columns = dataSet.getNumNumericalVars() + dataSet.getNumCategoricalVars();
    }

    @Override
    public int getRowCount() {
        return this.rows;
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    @Override
    public String getColumnName(int column) {
        if (column < this.dataSet.getNumCategoricalVars()) {
            return this.dataSet.getCategoryName(column);
        }
        return this.dataSet.getNumericName(column - this.dataSet.getNumCategoricalVars());
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex < this.dataSet.getNumCategoricalVars()) {
            return this.dataSet.getCategories()[columnIndex].getOptionName(this.dataSet.getDataPoint(rowIndex).getCategoricalValue(columnIndex));
        }
        return this.dataSet.getDataPoint(rowIndex).getNumericalValues().get(columnIndex - this.dataSet.getNumCategoricalVars());
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue instanceof Double) {
            this.dataSet.getDataPoint(rowIndex).getNumericalValues().set(columnIndex, (Double)aValue);
        } else if (aValue instanceof String) {
            this.dataSet.getDataPoint(rowIndex).getNumericalValues().set(columnIndex, Double.parseDouble((String)aValue));
        }
    }
}

