/*
 * Decompiled with CFR 0.152.
 */
package jsat.guitool;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.linear.Vec;

public class SingleVariableViewDialog
extends JDialog {
    private static final long serialVersionUID = -3635281795623474239L;
    final JPanel panel = new JPanel(new BorderLayout());
    final List<Vec> dataSets;
    final String[] titles;

    public SingleVariableViewDialog(DataSet dataSet) {
        this.dataSets = new ArrayList<Vec>(dataSet.getSampleSize());
        for (DataPoint dp : dataSet.getDataPoints()) {
            this.dataSets.add(dp.getNumericalValues());
        }
        this.titles = new String[dataSet.getNumNumericalVars()];
        for (int i = 0; i < this.titles.length; ++i) {
            this.titles[i] = dataSet.getNumericName(i);
        }
        final JComboBox<String> jc = new JComboBox<String>(this.titles);
        final JTextField minLabel = new JTextField();
        minLabel.setEditable(false);
        final JTextField maxLabel = new JTextField();
        maxLabel.setEditable(false);
        final JTextField meanLabel = new JTextField();
        meanLabel.setEditable(false);
        final JTextField medianLabel = new JTextField();
        medianLabel.setEditable(false);
        final JTextField stndDevLabel = new JTextField();
        stndDevLabel.setEditable(false);
        jc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = jc.getSelectedIndex();
                SingleVariableViewDialog.this.setTitle("Singl Var Stat: " + SingleVariableViewDialog.this.titles[index]);
                minLabel.setText(SingleVariableViewDialog.this.dataSets.get(index).min() + "");
                maxLabel.setText(SingleVariableViewDialog.this.dataSets.get(index).max() + "");
                medianLabel.setText(SingleVariableViewDialog.this.dataSets.get(index).median() + "");
                meanLabel.setText(SingleVariableViewDialog.this.dataSets.get(index).mean() + "");
                stndDevLabel.setText(SingleVariableViewDialog.this.dataSets.get(index).standardDeviation() + "");
            }
        });
        jc.setSelectedIndex(0);
        minLabel.setBorder(BorderFactory.createTitledBorder("Min:"));
        maxLabel.setBorder(BorderFactory.createTitledBorder("Max:"));
        meanLabel.setBorder(BorderFactory.createTitledBorder("Mean:"));
        medianLabel.setBorder(BorderFactory.createTitledBorder("Meadian:"));
        stndDevLabel.setBorder(BorderFactory.createTitledBorder("Standard Deviation:"));
        this.panel.add(jc, "North");
        JPanel subPanel = new JPanel(new GridLayout(5, 1));
        subPanel.add(minLabel);
        subPanel.add(maxLabel);
        subPanel.add(medianLabel);
        subPanel.add(meanLabel);
        subPanel.add(stndDevLabel);
        this.panel.add((Component)new JScrollPane(subPanel), "Center");
        this.setContentPane(this.panel);
    }
}

