/*
 * Decompiled with CFR 0.152.
 */
package jsat.guitool;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jsat.linear.distancemetrics.ChebyshevDistance;
import jsat.linear.distancemetrics.CosineDistance;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.distancemetrics.MahalanobisDistance;
import jsat.linear.distancemetrics.ManhattanDistance;
import jsat.parameters.BooleanParameter;
import jsat.parameters.DoubleParameter;
import jsat.parameters.IntParameter;
import jsat.parameters.MetricParameter;
import jsat.parameters.ObjectParameter;
import jsat.parameters.Parameter;
import jsat.parameters.Parameterized;

public class ParameterPanel
extends JPanel {
    private static final long serialVersionUID = -7333731204670319776L;
    final GridLayout gridLayout;
    final DistanceMetric[] distanceMetrics = new DistanceMetric[]{new EuclideanDistance(), new ManhattanDistance(), new ChebyshevDistance(), new CosineDistance(), new MahalanobisDistance()};
    private JButton jButtonOk;
    private JPanel jPanelParameters;

    public ParameterPanel(Parameterized parameterized) {
        this.initComponents();
        List<Parameter> parameters = parameterized.getParameters();
        this.gridLayout = new GridLayout(parameters.size(), 1);
        this.jPanelParameters.setLayout(this.gridLayout);
        for (Parameter param : parameters) {
            JComboBox<Object> comboBox;
            JCheckBox checkBox;
            JPanel subPanel = new JPanel(new BorderLayout());
            subPanel.setBorder(BorderFactory.createTitledBorder(param.getName()));
            if (param instanceof IntParameter) {
                final IntParameter intParam = (IntParameter)param;
                checkBox = new JCheckBox();
                checkBox.setSelected(true);
                checkBox.setEnabled(false);
                final JTextField textField = new JTextField(Integer.toString(intParam.getValue()));
                textField.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.change(e);
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.change(e);
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.change(e);
                    }

                    public void change(DocumentEvent e) {
                        try {
                            int newVal = Integer.parseInt(textField.getText().trim());
                            boolean good = intParam.setValue(newVal);
                            if (good) {
                                checkBox.setSelected(true);
                            } else {
                                this.badInput();
                            }
                        }
                        catch (Exception ex) {
                            this.badInput();
                        }
                    }

                    private void badInput() {
                        checkBox.setSelected(false);
                    }
                });
                subPanel.add((Component)textField, "Center");
                subPanel.add((Component)checkBox, "East");
                this.jPanelParameters.add(subPanel);
                continue;
            }
            if (param instanceof DoubleParameter) {
                final DoubleParameter doubleParam = (DoubleParameter)param;
                checkBox = new JCheckBox();
                checkBox.setSelected(true);
                checkBox.setEnabled(false);
                final JTextField textField = new JTextField(Double.toString(doubleParam.getValue()));
                textField.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.change(e);
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.change(e);
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.change(e);
                    }

                    public void change(DocumentEvent e) {
                        try {
                            double newVal = Double.parseDouble(textField.getText().trim());
                            boolean good = doubleParam.setValue(newVal);
                            if (good) {
                                checkBox.setSelected(true);
                            } else {
                                this.badInput();
                            }
                        }
                        catch (Exception ex) {
                            this.badInput();
                        }
                    }

                    private void badInput() {
                        checkBox.setSelected(false);
                    }
                });
                subPanel.add((Component)textField, "Center");
                subPanel.add((Component)checkBox, "East");
                this.jPanelParameters.add(subPanel);
                continue;
            }
            if (param instanceof BooleanParameter) {
                final BooleanParameter boolParam = (BooleanParameter)param;
                checkBox = new JCheckBox();
                checkBox.setSelected(boolParam.getValue());
                checkBox.setEnabled(true);
                checkBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        boolParam.setValue(checkBox.isSelected());
                    }
                });
                subPanel.add((Component)checkBox, "Center");
                this.jPanelParameters.add(subPanel);
                continue;
            }
            if (param instanceof ObjectParameter) {
                final ObjectParameter objParam = (ObjectParameter)param;
                comboBox = new JComboBox<Object>(objParam.parameterOptions().toArray());
                comboBox.setSelectedItem(objParam.getObject());
                comboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        objParam.setObject(comboBox.getSelectedItem());
                    }
                });
                List options = objParam.parameterOptions();
                for (int i = 0; i < options.size(); ++i) {
                    if (!options.get(i).toString().equals(objParam.getObject().toString())) continue;
                    comboBox.setSelectedIndex(i);
                }
                subPanel.add(comboBox, "Center");
                this.jPanelParameters.add(subPanel);
                continue;
            }
            if (!(param instanceof MetricParameter)) continue;
            final MetricParameter metricParam = (MetricParameter)param;
            comboBox = new JComboBox<DistanceMetric>(this.distanceMetrics);
            for (int i = 0; i < this.distanceMetrics.length; ++i) {
                if (!this.distanceMetrics[i].toString().equals(metricParam.getMetric().toString())) continue;
                comboBox.setSelectedIndex(i);
            }
            comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    metricParam.setMetric(ParameterPanel.this.distanceMetrics[comboBox.getSelectedIndex()].clone());
                }
            });
            subPanel.add(comboBox, "Center");
            this.jPanelParameters.add(subPanel);
        }
    }

    public JButton getjButtonOk() {
        return this.jButtonOk;
    }

    public static void showParameterDiag(Window owner, String title, Parameterized parameterized) {
        ParameterPanel pp = new ParameterPanel(parameterized);
        final JDialog jd = new JDialog(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        jd.setContentPane(pp);
        pp.getjButtonOk().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jd.setVisible(false);
            }
        });
        jd.pack();
        jd.setVisible(true);
    }

    private void initComponents() {
        this.jButtonOk = new JButton();
        this.jPanelParameters = new JPanel();
        this.jButtonOk.setText("Ok");
        this.jPanelParameters.setBorder(BorderFactory.createTitledBorder("Parameters"));
        GroupLayout jPanelParametersLayout = new GroupLayout(this.jPanelParameters);
        this.jPanelParameters.setLayout(jPanelParametersLayout);
        jPanelParametersLayout.setHorizontalGroup(jPanelParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanelParametersLayout.setVerticalGroup(jPanelParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 225, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 313, Short.MAX_VALUE).addComponent(this.jButtonOk)).addComponent(this.jPanelParameters, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelParameters, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonOk).addContainerGap()));
    }
}

