/*
 * Decompiled with CFR 0.152.
 */
package jsat.guitool;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jsat.DataSet;
import jsat.testing.StatisticTest;
import jsat.testing.onesample.OneSampleTest;

public class OneSampleTestDialog
extends JFrame {
    private static final long serialVersionUID = 4723100928784978203L;
    final OneSampleTest test;
    final DataSet dataSet;
    protected JTextField pValueField;

    public OneSampleTestDialog(final OneSampleTest test, final DataSet dataSet) {
        super(test.testName());
        this.test = test;
        this.dataSet = dataSet;
        this.getContentPane().setLayout(new BorderLayout());
        this.pValueField = new JTextField("0");
        this.pValueField.setEditable(false);
        final JComboBox<StatisticTest.H1> jcb = new JComboBox<StatisticTest.H1>(test.validAlternate());
        test.setAltHypothesis((StatisticTest.H1)((Object)jcb.getSelectedItem()));
        jcb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                test.setAltHypothesis((StatisticTest.H1)((Object)jcb.getSelectedItem()));
                try {
                    OneSampleTestDialog.this.pValueField.setText(Double.toString(test.pValue()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        final JTextField altHypoFeild = new JTextField("0.0");
        altHypoFeild.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent de) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                this.update();
            }

            private void update() {
                try {
                    double d = Double.parseDouble(altHypoFeild.getText());
                    test.setAltVar(d);
                    OneSampleTestDialog.this.pValueField.setText(Double.toString(test.pValue()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JPanel hypothesisPanel = new JPanel();
        hypothesisPanel.add(new JLabel(test.getNullVar()));
        hypothesisPanel.add(jcb);
        hypothesisPanel.add(new JLabel(test.getAltVar() + ":"));
        hypothesisPanel.add(altHypoFeild);
        hypothesisPanel.setBorder(BorderFactory.createTitledBorder("Hypothesis"));
        this.getContentPane().add((Component)hypothesisPanel, "North");
        JTabbedPane paremeters = new JTabbedPane();
        String[] feildNames = test.getTestVars();
        final JTextField[] feilds = new JTextField[feildNames.length];
        JPanel statsPanel = new JPanel();
        statsPanel.setLayout(new BoxLayout(statsPanel, 1));
        for (int i = 0; i < feildNames.length; ++i) {
            JPanel tmp = new JPanel();
            tmp.add(new JLabel(feildNames[i] + ": "));
            feilds[i] = new JTextField("1.0");
            feilds[i].getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent de) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent de) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent de) {
                    this.update();
                }

                private void update() {
                    double[] vals = new double[feilds.length];
                    try {
                        for (int i = 0; i < vals.length; ++i) {
                            vals[i] = Double.parseDouble(feilds[i].getText());
                        }
                        test.setTestVars(vals);
                        OneSampleTestDialog.this.pValueField.setText(Double.toString(test.pValue()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            tmp.add(feilds[i]);
            statsPanel.add(tmp);
        }
        paremeters.add("Stats", statsPanel);
        JPanel datasetPanel = new JPanel();
        if (dataSet.getNumNumericalVars() > 0) {
            String[] titles = new String[dataSet.getNumNumericalVars()];
            for (int i = 0; i < titles.length; ++i) {
                titles[i] = dataSet.getNumericName(i);
            }
            final JComboBox<String> dataCB = new JComboBox<String>(titles);
            dataCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        test.setTestUsingData(dataSet.getNumericColumn(dataCB.getSelectedIndex()));
                        OneSampleTestDialog.this.pValueField.setText(Double.toString(test.pValue()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            dataCB.setBorder(BorderFactory.createTitledBorder("Select Data Set:"));
            datasetPanel.add(dataCB);
        } else {
            JTextField jtf = new JTextField("You must have loaded some\ndata set to use this feature");
            jtf.setEditable(false);
            datasetPanel.add(jtf);
        }
        paremeters.add("Data", datasetPanel);
        this.getContentPane().add((Component)paremeters, "Center");
        JPanel pValPanel = new JPanel();
        pValPanel.setBorder(BorderFactory.createTitledBorder("P Value"));
        pValPanel.add(this.pValueField);
        this.getContentPane().add((Component)pValPanel, "South");
    }
}

