/*
 * Decompiled with CFR 0.152.
 */
package jsat.guitool;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jsat.ARFFLoader;
import jsat.DataSet;
import jsat.SimpleDataSet;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.Classifier;
import jsat.clustering.OPTICS;
import jsat.datatransform.DataTransformProcess;
import jsat.datatransform.LinearTransform;
import jsat.datatransform.NumericalToHistogram;
import jsat.datatransform.PCA;
import jsat.datatransform.PolynomialTransform;
import jsat.datatransform.UnitVarianceTransform;
import jsat.datatransform.WhitenedPCA;
import jsat.datatransform.WhitenedZCA;
import jsat.datatransform.ZeroMeanTransform;
import jsat.distributions.ChiSquared;
import jsat.distributions.ContinuousDistribution;
import jsat.distributions.Exponential;
import jsat.distributions.FisherSendor;
import jsat.distributions.Gamma;
import jsat.distributions.LogNormal;
import jsat.distributions.Normal;
import jsat.distributions.Uniform;
import jsat.distributions.Weibull;
import jsat.distributions.empirical.KernelDensityEstimator;
import jsat.distributions.empirical.kernelfunc.GaussKF;
import jsat.graphing.CategoryPlot;
import jsat.graphing.Graph2D;
import jsat.graphing.Histogram;
import jsat.graphing.ParallelCoordinatesPlot;
import jsat.graphing.ProgressPanel;
import jsat.graphing.QQPlotData;
import jsat.graphing.QQPlotDistribution;
import jsat.graphing.ReachabilityPlot;
import jsat.graphing.ScatterPlot;
import jsat.graphing.ScatterplotMatrix;
import jsat.guitool.ClassifierCVEvaluation;
import jsat.guitool.ClassifierSelectionDialog;
import jsat.guitool.DataSetSelection;
import jsat.guitool.DistributionSelectionDialog;
import jsat.guitool.GraphDialog;
import jsat.guitool.OneSampleTestDialog;
import jsat.guitool.SingleVariableViewDialog;
import jsat.guitool.VecTableModel;
import jsat.linear.Vec;
import jsat.math.Function;
import jsat.math.SimpleLinearRegression;
import jsat.testing.goodnessoffit.KSTest;
import jsat.testing.onesample.TTest;
import jsat.testing.onesample.ZTest;
import jsat.utils.ProbailityMatch;

public class MainGUI
extends JFrame {
    private static final long serialVersionUID = -1965204891107163706L;
    ContinuousDistribution[] distributions = new ContinuousDistribution[]{new Normal(), new LogNormal(), new Exponential(), new ChiSquared(10.0), new Gamma(2.0, 1.0), new FisherSendor(10.0, 10.0), new Weibull(2.0, 1.0), new Uniform(0.0, 1.0)};
    SimpleDataSet data;
    DataTransformProcess dtp;
    private JMenuItem jItemClearTransforms;
    private JMenuItem jItemTransLinear;
    private JMenuItem jItemTransPCA;
    private JMenuItem jItemTransPolynomial;
    private JMenuItem jItemTransUnitVariance;
    private JMenuItem jItemTransWhitenedPCA;
    private JMenuItem jItemTransWhitenedZCA;
    private JMenuItem jItemTransZeroMean;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenu jMenu5;
    private JMenu jMenu6;
    private JMenuBar jMenuBar1;
    private JMenu jMenuCVisualize;
    private JMenuItem jMenuClassPCA;
    private JMenuItem jMenuClassWhitePCA;
    private JMenu jMenuClassification;
    private JMenuItem jMenuCrossValidateTest;
    private JMenu jMenuCurTransforms;
    private JMenu jMenuFile;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItemClassParaCoords;
    private JMenuItem jMenuItemHisto;
    private JMenuItem jMenuItemKDE;
    private JMenuItem jMenuItemLinearRegress;
    private JMenuItem jMenuItemNumericHistro;
    private JMenuItem jMenuItemOneSamT;
    private JMenuItem jMenuItemOneSampZ;
    private JMenuItem jMenuItemOpen;
    private JMenuItem jMenuItemPCA;
    private JMenuItem jMenuItemParaCoords;
    private JMenuItem jMenuItemQQData;
    private JMenuItem jMenuItemQQDist;
    private JMenuItem jMenuItemReachabilityPlot;
    private JMenuItem jMenuItemScatter;
    private JMenuItem jMenuItemScatterMatrix;
    private JMenuItem jMenuItemSingleVariable;
    private JMenuItem jMenuItemWhitePCA;
    private JMenuItem jMenuKSSearch;
    private JMenu jMenuPredictingClass;
    private JMenu jMenuTransform;
    private JMenu jMenuVisualize;
    private JPopupMenu.Separator jSeparator1;
    private JFileChooser jfc;

    public MainGUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println("Error setting native LAF: " + e);
        }
        this.dtp = new DataTransformProcess();
        this.initComponents();
        this.jMenuItemHisto.setEnabled(false);
        this.jMenuItemQQData.setEnabled(false);
        this.jMenuItemQQDist.setEnabled(false);
        this.jMenuItemScatter.setEnabled(false);
        this.jMenuItemScatterMatrix.setEnabled(false);
        this.jMenuItemSingleVariable.setEnabled(false);
        this.setSize(400, 300);
    }

    private ClassificationDataSet getClassificationData() {
        if (this.jMenuPredictingClass.getItemCount() == 0) {
            return null;
        }
        int selected = -1;
        for (int i = 0; i < this.jMenuPredictingClass.getItemCount(); ++i) {
            JRadioButtonMenuItem button = (JRadioButtonMenuItem)this.jMenuPredictingClass.getItem(i);
            if (!button.isSelected()) continue;
            selected = i;
            break;
        }
        ClassificationDataSet cds = new ClassificationDataSet(this.data.getBackingList(), selected);
        for (int i = 0; i < this.data.getNumNumericalVars(); ++i) {
            cds.setNumericName(this.data.getNumericName(i), i);
        }
        return cds;
    }

    private void initComponents() {
        this.jfc = new JFileChooser();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemOpen = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.jMenuVisualize = new JMenu();
        this.jMenuItemPCA = new JMenuItem();
        this.jMenuItemWhitePCA = new JMenuItem();
        this.jMenuItemParaCoords = new JMenuItem();
        this.jMenuItemReachabilityPlot = new JMenuItem();
        this.jMenuItemHisto = new JMenuItem();
        this.jMenuItemKDE = new JMenuItem();
        this.jMenuItemScatter = new JMenuItem();
        this.jMenuItemScatterMatrix = new JMenuItem();
        this.jMenuItemQQDist = new JMenuItem();
        this.jMenuItemQQData = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenu4 = new JMenu();
        this.jMenu5 = new JMenu();
        this.jMenuKSSearch = new JMenuItem();
        this.jMenu6 = new JMenu();
        this.jMenuItemOneSampZ = new JMenuItem();
        this.jMenuItemOneSamT = new JMenuItem();
        this.jMenuItemSingleVariable = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItemLinearRegress = new JMenuItem();
        this.jMenuClassification = new JMenu();
        this.jMenuPredictingClass = new JMenu();
        this.jMenuCVisualize = new JMenu();
        this.jMenuClassPCA = new JMenuItem();
        this.jMenuClassWhitePCA = new JMenuItem();
        this.jMenuItemClassParaCoords = new JMenuItem();
        this.jMenuCrossValidateTest = new JMenuItem();
        this.jMenuTransform = new JMenu();
        this.jMenuCurTransforms = new JMenu();
        this.jItemClearTransforms = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jItemTransUnitVariance = new JMenuItem();
        this.jItemTransZeroMean = new JMenuItem();
        this.jItemTransPCA = new JMenuItem();
        this.jItemTransWhitenedPCA = new JMenuItem();
        this.jItemTransWhitenedZCA = new JMenuItem();
        this.jItemTransPolynomial = new JMenuItem();
        this.jItemTransLinear = new JMenuItem();
        this.jMenuItemNumericHistro = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.jMenuFile.setText("File");
        this.jMenuItemOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItemOpen.setText("Open");
        this.jMenuItemOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuItemOpenActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemOpen);
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.jMenuItem1.setText("Exit");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenu1.setText("View");
        this.jMenuVisualize.setText("Visualize");
        this.jMenuItemPCA.setText("PCA");
        this.jMenuItemPCA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuItemPCAActionPerformed(evt);
            }
        });
        this.jMenuVisualize.add(this.jMenuItemPCA);
        this.jMenuItemWhitePCA.setText("Whitened PCA");
        this.jMenuItemWhitePCA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuItemWhitePCAActionPerformed(evt);
            }
        });
        this.jMenuVisualize.add(this.jMenuItemWhitePCA);
        this.jMenuItemParaCoords.setText("Parallel Corrdinates");
        this.jMenuItemParaCoords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuItemParaCoordsActionPerformed(evt);
            }
        });
        this.jMenuVisualize.add(this.jMenuItemParaCoords);
        this.jMenuItemReachabilityPlot.setText("Reachability Plot");
        this.jMenuItemReachabilityPlot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuItemReachabilityPlotActionPerformed(evt);
            }
        });
        this.jMenuVisualize.add(this.jMenuItemReachabilityPlot);
        this.jMenu1.add(this.jMenuVisualize);
        this.jMenuItemHisto.setText("Histogram");
        this.jMenuItemHisto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuItemHistoActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItemHisto);
        this.jMenuItemKDE.setText("KDE Estimate");
        this.jMenuItemKDE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuItemKDEActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItemKDE);
        this.jMenuItemScatter.setText("Scatter Plot");
        this.jMenuItemScatter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuItemScatterActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItemScatter);
        this.jMenuItemScatterMatrix.setText("Scatter Matrix");
        this.jMenuItemScatterMatrix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuItemScatterMatrixActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItemScatterMatrix);
        this.jMenuItemQQDist.setText("QQ Plot Distribution");
        this.jMenuItemQQDist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuItemQQDistActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItemQQDist);
        this.jMenuItemQQData.setText("QQ Plot Data");
        this.jMenuItemQQData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuItemQQDataActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItemQQData);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Statistics");
        this.jMenu4.setText("Tests");
        this.jMenu5.setText("Goodness of Fit");
        this.jMenuKSSearch.setText(" Kolmogorov Search");
        this.jMenuKSSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuKSSearchActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jMenuKSSearch);
        this.jMenu4.add(this.jMenu5);
        this.jMenu6.setText("One Sample");
        this.jMenuItemOneSampZ.setText("Z-Test");
        this.jMenuItemOneSampZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuItemOneSampZActionPerformed(evt);
            }
        });
        this.jMenu6.add(this.jMenuItemOneSampZ);
        this.jMenuItemOneSamT.setText("T-Test");
        this.jMenuItemOneSamT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuItemOneSamTActionPerformed(evt);
            }
        });
        this.jMenu6.add(this.jMenuItemOneSamT);
        this.jMenu4.add(this.jMenu6);
        this.jMenu2.add(this.jMenu4);
        this.jMenuItemSingleVariable.setText("Single Variable");
        this.jMenuItemSingleVariable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuItemSingleVariableActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItemSingleVariable);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu3.setText("Regression");
        this.jMenuItemLinearRegress.setText("Linear");
        this.jMenuItemLinearRegress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuItemLinearRegressActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItemLinearRegress);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenuClassification.setText("Classification");
        this.jMenuPredictingClass.setText("Predicting");
        this.jMenuClassification.add(this.jMenuPredictingClass);
        this.jMenuCVisualize.setText("Visualize");
        this.jMenuClassPCA.setText("PCA");
        this.jMenuClassPCA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuClassPCAActionPerformed(evt);
            }
        });
        this.jMenuCVisualize.add(this.jMenuClassPCA);
        this.jMenuClassWhitePCA.setText("Whitened PCA");
        this.jMenuClassWhitePCA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuClassWhitePCAActionPerformed(evt);
            }
        });
        this.jMenuCVisualize.add(this.jMenuClassWhitePCA);
        this.jMenuItemClassParaCoords.setText("Parallel Coordinates");
        this.jMenuItemClassParaCoords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuItemClassParaCoordsActionPerformed(evt);
            }
        });
        this.jMenuCVisualize.add(this.jMenuItemClassParaCoords);
        this.jMenuClassification.add(this.jMenuCVisualize);
        this.jMenuCrossValidateTest.setText("Cross Validate");
        this.jMenuCrossValidateTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuCrossValidateTestActionPerformed(evt);
            }
        });
        this.jMenuClassification.add(this.jMenuCrossValidateTest);
        this.jMenuBar1.add(this.jMenuClassification);
        this.jMenuTransform.setText("Transform");
        this.jMenuCurTransforms.setText("Current Transforms");
        this.jMenuTransform.add(this.jMenuCurTransforms);
        this.jItemClearTransforms.setText("Clear Transforms");
        this.jItemClearTransforms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jItemClearTransformsActionPerformed(evt);
            }
        });
        this.jMenuTransform.add(this.jItemClearTransforms);
        this.jMenuTransform.add(this.jSeparator1);
        this.jItemTransUnitVariance.setText("Unit Variance");
        this.jItemTransUnitVariance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jItemTransUnitVarianceActionPerformed(evt);
            }
        });
        this.jMenuTransform.add(this.jItemTransUnitVariance);
        this.jItemTransZeroMean.setText("Zero Mean");
        this.jItemTransZeroMean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jItemTransZeroMeanActionPerformed(evt);
            }
        });
        this.jMenuTransform.add(this.jItemTransZeroMean);
        this.jItemTransPCA.setText("PCA");
        this.jItemTransPCA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jItemTransPCAActionPerformed(evt);
            }
        });
        this.jMenuTransform.add(this.jItemTransPCA);
        this.jItemTransWhitenedPCA.setText("Whitened PCA");
        this.jItemTransWhitenedPCA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jItemTransWhitenedPCAActionPerformed(evt);
            }
        });
        this.jMenuTransform.add(this.jItemTransWhitenedPCA);
        this.jItemTransWhitenedZCA.setText("Whitened ZCA");
        this.jItemTransWhitenedZCA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jItemTransWhitenedZCAActionPerformed(evt);
            }
        });
        this.jMenuTransform.add(this.jItemTransWhitenedZCA);
        this.jItemTransPolynomial.setText("Polynomial");
        this.jItemTransPolynomial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jItemTransPolynomialActionPerformed(evt);
            }
        });
        this.jMenuTransform.add(this.jItemTransPolynomial);
        this.jItemTransLinear.setText("Linear");
        this.jItemTransLinear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jItemTransLinearActionPerformed(evt);
            }
        });
        this.jMenuTransform.add(this.jItemTransLinear);
        this.jMenuItemNumericHistro.setText("Numeric to Histogram");
        this.jMenuItemNumericHistro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jMenuItemNumericHistroActionPerformed(evt);
            }
        });
        this.jMenuTransform.add(this.jMenuItemNumericHistro);
        this.jMenuBar1.add(this.jMenuTransform);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void jMenuItemOpenActionPerformed(ActionEvent evt) {
        int retVal = this.jfc.showOpenDialog(this);
        if (retVal == 0) {
            File file = this.jfc.getSelectedFile();
            try {
                this.data = ARFFLoader.loadArffFile(file);
                VecTableModel vt = new VecTableModel(this.data);
                JTable jt = new JTable(vt);
                this.getContentPane().removeAll();
                this.getContentPane().add(new JScrollPane(jt));
                this.updateMenuPreductingClassItems();
                this.validate();
                this.jMenuItemHisto.setEnabled(true);
                this.jMenuItemQQData.setEnabled(true);
                this.jMenuItemQQDist.setEnabled(true);
                this.jMenuItemScatter.setEnabled(true);
                this.jMenuItemScatterMatrix.setEnabled(true);
                this.jMenuItemSingleVariable.setEnabled(true);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void jMenuItemScatterActionPerformed(ActionEvent evt) {
        if (this.data == null || this.data.getNumNumericalVars() < 2) {
            JOptionPane.showMessageDialog(null, "You need at least 2 sets of data for a scatter plot", "Scatter Plot error", 0);
            return;
        }
        DataSetSelection dss = new DataSetSelection(null, "Select X and Y Axis", this.data, new String[]{"X axis", "Y axis"});
        int[] axie = dss.getSelections();
        ScatterPlot sp = new ScatterPlot(this.data.getNumericColumn(axie[0]), this.data.getNumericColumn(axie[1]));
        sp.setXAxisTtile(this.data.getNumericName(axie[0]));
        sp.setYAxisTtile(this.data.getNumericName(axie[1]));
        GraphDialog gd = new GraphDialog(null, "Sactter Plot of " + this.data.getNumericName(axie[0]) + " & " + this.data.getNumericName(axie[1]), sp);
        gd.setSize(300, 300);
        gd.setVisible(true);
    }

    private void jMenuItemQQDistActionPerformed(ActionEvent evt) {
        DataSetSelection dss = new DataSetSelection(null, "Select data to check", this.data, new String[]{"QQ Plot Data"});
        int[] axie = dss.getSelections();
        for (int i = 0; i < this.distributions.length; ++i) {
            try {
                this.distributions[i].setUsingData(this.data.getNumericColumn(axie[0]));
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        DistributionSelectionDialog dsd = new DistributionSelectionDialog(null, "Select distribution to compare against", this.distributions);
        ContinuousDistribution dist = dsd.getDistribution();
        QQPlotDistribution qq = new QQPlotDistribution(dist, this.data.getNumericColumn(axie[0]));
        qq.setYAxisTtile(this.data.getNumericName(axie[0]));
        GraphDialog gd = new GraphDialog(null, "QQ Plot of " + this.data.getNumericName(axie[0]), qq);
        gd.setSize(300, 300);
        gd.setVisible(true);
    }

    private void jMenuItemQQDataActionPerformed(ActionEvent evt) {
        DataSetSelection dss = new DataSetSelection(null, "Select data to check", this.data, new String[]{"X Axis", "Y Axis"});
        int[] axie = dss.getSelections();
        QQPlotData qq = new QQPlotData(this.data.getNumericColumn(axie[1]), this.data.getNumericColumn(axie[0]));
        qq.setXAxisTtile(this.data.getNumericName(axie[0]));
        qq.setYAxisTtile(this.data.getNumericName(axie[1]));
        GraphDialog gd = new GraphDialog(null, "QQ Plot of " + this.data.getNumericName(axie[0]) + " & " + this.data.getNumericName(axie[1]), qq);
        gd.setSize(300, 300);
        gd.setVisible(true);
    }

    private void jMenuItemSingleVariableActionPerformed(ActionEvent evt) {
        SingleVariableViewDialog svvd = new SingleVariableViewDialog(this.data);
        svvd.pack();
        svvd.setVisible(true);
    }

    private void jMenuItemScatterMatrixActionPerformed(ActionEvent evt) {
        ScatterplotMatrix sm = new ScatterplotMatrix(null, "Scatter Matrix", this.data);
        sm.setSize(600, 600);
        sm.setVisible(true);
    }

    private void jMenuItemHistoActionPerformed(ActionEvent evt) {
        DataSetSelection dss = new DataSetSelection(null, "Select data to create histogram from", this.data, new String[]{"Histogram Data"});
        int[] axie = dss.getSelections();
        Histogram hh = new Histogram(this.data.getNumericColumn(axie[0]));
        hh.setXAxisTtile(this.data.getNumericName(axie[0]));
        GraphDialog gd = new GraphDialog(null, "Histogram of " + this.data.getNumericName(axie[0]), hh);
        gd.setSize(300, 300);
        gd.setVisible(true);
    }

    private void jMenuItemLinearRegressActionPerformed(ActionEvent evt) {
        if (this.data.getNumNumericalVars() < 2) {
            JOptionPane.showMessageDialog(null, "You need at least 2 sets of data for Linear Regression", "Linear Regression error", 0);
            return;
        }
        DataSetSelection dss = new DataSetSelection(null, "Select data to perform Linear Regression on", this.data, new String[]{"Y data", "X data"});
        int[] axie = dss.getSelections();
        final double[] ab = SimpleLinearRegression.regres(this.data.getNumericColumn(axie[1]), this.data.getNumericColumn(axie[0]));
        Function linearFunc = new Function(){
            private static final long serialVersionUID = -2002581116871317604L;

            @Override
            public double f(double ... x) {
                return ab[0] + ab[1] * x[0];
            }

            @Override
            public double f(Vec x) {
                return this.f(x.get(0));
            }
        };
        ScatterPlot sp = new ScatterPlot(this.data.getNumericColumn(axie[1]), this.data.getNumericColumn(axie[0]));
        sp.setRegressionFunction(linearFunc);
        sp.setXAxisTtile(this.data.getNumericName(axie[1]));
        sp.setYAxisTtile(this.data.getNumericName(axie[0]));
        GraphDialog gd = new GraphDialog(null, "y = " + ab[0] + " + " + ab[1] + "x, Linear Regression of " + this.data.getNumericName(axie[0]) + " & " + this.data.getNumericName(axie[1]), sp);
        gd.setSize(300, 300);
        gd.setVisible(true);
    }

    private void jMenuKSSearchActionPerformed(ActionEvent evt) {
        DataSetSelection dss = new DataSetSelection(null, "Select data to attempt to detect the distribution of", this.data, new String[]{"Data Set"});
        int[] axie = dss.getSelections();
        for (int i = 0; i < this.distributions.length; ++i) {
            try {
                this.distributions[i].setUsingData(this.data.getNumericColumn(axie[0]));
                continue;
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
        }
        KSTest ks = new KSTest(this.data.getNumericColumn(axie[0]));
        ArrayList<ProbailityMatch<ContinuousDistribution>> pValues = new ArrayList<ProbailityMatch<ContinuousDistribution>>(this.distributions.length);
        for (int i = 0; i < this.distributions.length; ++i) {
            try {
                double p = ks.testDist(this.distributions[i]);
                if (!(p >= 0.05)) continue;
                pValues.add(new ProbailityMatch<ContinuousDistribution>(p, this.distributions[i]));
                continue;
            }
            catch (ArithmeticException ex) {
                // empty catch block
            }
        }
        Collections.sort(pValues);
        Collections.reverse(pValues);
        String[] possible = new String[pValues.size()];
        for (int i = 0; i < pValues.size(); ++i) {
            possible[i] = ((ContinuousDistribution)((ProbailityMatch)pValues.get(i)).getMatch()).getDescriptiveName();
        }
        JList<String> jl = new JList<String>(possible);
        JFrame jf = new JFrame("Possiible Distribution matches for " + this.data.getNumericName(axie[0]));
        if (possible.length > 0) {
            JPanel jp = new JPanel(new GridLayout(1, 1));
            jp.add(new JScrollPane(jl));
            jf.setContentPane(jp);
        } else {
            JPanel jp = new JPanel(new GridLayout(1, 1));
            jp.add(new JLabel("No known distribution seems to match this data set"));
            jf.setContentPane(jp);
        }
        jf.setVisible(true);
        jf.pack();
    }

    private void jMenuItemOneSampZActionPerformed(ActionEvent evt) {
        OneSampleTestDialog dia = new OneSampleTestDialog(new ZTest(), this.data);
        dia.setSize(300, 300);
        dia.setVisible(true);
    }

    private void jMenuItemOneSamTActionPerformed(ActionEvent evt) {
        OneSampleTestDialog dia = new OneSampleTestDialog(new TTest(), this.data);
        dia.setSize(300, 300);
        dia.setVisible(true);
    }

    private void jMenuClassPCAActionPerformed(ActionEvent evt) {
        ClassificationDataSet cds = this.getClassificationData();
        if (cds == null) {
            JOptionPane.showMessageDialog(this.rootPane, "This data set has no categorical attributes to use as a class", "Can not perform class visualization", 0);
        } else if (cds.getNumNumericalVars() < 2) {
            JOptionPane.showMessageDialog(this.rootPane, "This data set does not have enough numerical attributes to plot", "Can not perform class visualization", 0);
        } else {
            cds.applyTransform(new ZeroMeanTransform(cds));
            cds.applyTransform(new PCA(cds, 2));
            GraphDialog dialog = new GraphDialog(null, "PCA Visualization", new CategoryPlot(cds));
            dialog.setSize(400, 400);
            dialog.setVisible(true);
        }
    }

    private void jMenuCrossValidateTestActionPerformed(ActionEvent evt) {
        ClassifierSelectionDialog csd = new ClassifierSelectionDialog(this.getClassificationData(), this);
        csd.pack();
        csd.setVisible(true);
        if (csd.isCanceled()) {
            return;
        }
        List<Classifier> classifiers = csd.getSelectedClassifiers();
        List<String> classifierNames = csd.getSelectedNames();
        if (classifiers.isEmpty()) {
            return;
        }
        ClassifierCVEvaluation eval = new ClassifierCVEvaluation(classifiers, classifierNames, this.getClassificationData(), this, "Title", false, this.dtp);
    }

    private void jMenuItemClassParaCoordsActionPerformed(ActionEvent evt) {
        ClassificationDataSet cds = this.getClassificationData();
        if (cds == null) {
            JOptionPane.showMessageDialog(this.rootPane, "This data set has no categorical attributes to use as a class", "Can not perform class visualization", 0);
        } else {
            GraphDialog dialog = new GraphDialog(null, "Parallel Coordinates", new ParallelCoordinatesPlot(cds));
            dialog.setSize(400, 400);
            dialog.setVisible(true);
        }
    }

    private void jMenuItemKDEActionPerformed(ActionEvent evt) {
        DataSetSelection dss = new DataSetSelection(null, "Select data to create KDE from", this.data, new String[]{"KDE Data"});
        int[] axie = dss.getSelections();
        Vec dataVec = this.data.getNumericColumn(axie[0]);
        final KernelDensityEstimator kde = new KernelDensityEstimator(dataVec, GaussKF.getInstance());
        double shift = kde.getBandwith() * 2.0;
        Graph2D hh = new Graph2D(dataVec.min() - shift, dataVec.max() + shift, 0.0, kde.pdf(kde.mode()) * 1.1){
            private static final long serialVersionUID = 2487065927446465755L;

            @Override
            protected void paintWork(Graphics g, int imageWidth, int imageHeight, ProgressPanel pp) {
                super.paintWork(g, imageWidth, imageHeight, pp);
                g.setColor(Color.BLUE);
                this.drawFunction((Graphics2D)g, ContinuousDistribution.getFunctionPDF(kde));
            }
        };
        hh.setXAxisTtile(this.data.getNumericName(axie[0]));
        GraphDialog gd = new GraphDialog(null, "KDE Estimation of " + this.data.getNumericName(axie[0]), hh);
        gd.setSize(300, 300);
        gd.setVisible(true);
    }

    private void jMenuItemReachabilityPlotActionPerformed(ActionEvent evt) {
        final JDialog waitDialog = new JDialog(this, "Compuring", true);
        ProgressPanel pp = new ProgressPanel("Computing OPTICS", "Reachability Plot will be taken from OPTICS");
        waitDialog.setDefaultCloseOperation(0);
        waitDialog.setContentPane(pp);
        waitDialog.pack();
        final MainGUI gui = this;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                final OPTICS optics = new OPTICS();
                optics.cluster(MainGUI.this.data);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ReachabilityPlot plot = new ReachabilityPlot(optics.getReachabilityArray());
                        JDialog jdialog = new JDialog((Frame)gui, "Reachability Plot");
                        jdialog.setContentPane(new JScrollPane(plot));
                        jdialog.setSize(plot.getPreferredSize());
                        jdialog.setVisible(true);
                        waitDialog.setVisible(false);
                    }
                });
            }
        });
        thread.start();
        waitDialog.setVisible(true);
    }

    private void jMenuItemParaCoordsActionPerformed(ActionEvent evt) {
        GraphDialog dialog = new GraphDialog(null, "Parallel Coordinates", new ParallelCoordinatesPlot(this.data));
        dialog.setSize(400, 400);
        dialog.setVisible(true);
    }

    private void jMenuClassWhitePCAActionPerformed(ActionEvent evt) {
        ClassificationDataSet cds = this.getClassificationData();
        if (cds == null) {
            JOptionPane.showMessageDialog(this.rootPane, "This data set has no categorical attributes to use as a class", "Can not perform class visualization", 0);
        } else if (cds.getNumNumericalVars() < 2) {
            JOptionPane.showMessageDialog(this.rootPane, "This data set does not have enough numerical attributes to plot", "Can not perform class visualization", 0);
        } else {
            cds.applyTransform(new ZeroMeanTransform(cds));
            cds.applyTransform(new WhitenedPCA((DataSet)cds, 2));
            GraphDialog dialog = new GraphDialog(null, "whitened PCA Visualization", new CategoryPlot(cds));
            dialog.setSize(400, 400);
            dialog.setVisible(true);
        }
    }

    private void jMenuItemWhitePCAActionPerformed(ActionEvent evt) {
        SimpleDataSet sds = new SimpleDataSet(this.data.getDataPoints());
        if (sds == null) {
            JOptionPane.showMessageDialog(this.rootPane, "This data set has no categorical attributes to use as a class", "Can not perform visualization", 0);
        } else if (sds.getNumNumericalVars() < 2) {
            JOptionPane.showMessageDialog(this.rootPane, "This data set does not have enough numerical attributes to plot", "Can not perform visualization", 0);
        } else {
            sds.applyTransform(new ZeroMeanTransform(sds));
            sds.applyTransform(new WhitenedPCA((DataSet)sds, 2));
            GraphDialog dialog = new GraphDialog(null, "whitened PCA Visualization", new ScatterPlot(sds.getNumericColumn(0), sds.getNumericColumn(1)));
            dialog.setSize(400, 400);
            dialog.setVisible(true);
        }
    }

    private void jMenuItemPCAActionPerformed(ActionEvent evt) {
        SimpleDataSet sds = new SimpleDataSet(this.data.getDataPoints());
        if (sds == null) {
            JOptionPane.showMessageDialog(this.rootPane, "This data set has no categorical attributes to use as a class", "Can not perform visualization", 0);
        } else if (sds.getNumNumericalVars() < 2) {
            JOptionPane.showMessageDialog(this.rootPane, "This data set does not have enough numerical attributes to plot", "Can not perform visualization", 0);
        } else {
            sds.applyTransform(new ZeroMeanTransform(sds));
            sds.applyTransform(new PCA(sds, 2));
            GraphDialog dialog = new GraphDialog(null, "PCA Visualization", new ScatterPlot(sds.getNumericColumn(0), sds.getNumericColumn(1)));
            dialog.setSize(400, 400);
            dialog.setVisible(true);
        }
    }

    private void jItemTransPolynomialActionPerformed(ActionEvent evt) {
        String s = JOptionPane.showInputDialog(this.rootPane, "Please Specify the degree for the transform", "Polynomial Transform", 3);
        try {
            int degree = Integer.parseInt(s);
            if (degree < 1) {
                throw new RuntimeException();
            }
            this.dtp.addTransform(new PolynomialTransform.PolyTransformFactory(degree));
            this.jMenuCurTransforms.add(new JLabel(" Polynomial of degree " + degree + " "));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jItemTransUnitVarianceActionPerformed(ActionEvent evt) {
        this.dtp.addTransform(new UnitVarianceTransform.UnitVarianceTransformFactory());
        this.jMenuCurTransforms.add(new JLabel(" Unit Variance "));
    }

    private void jItemTransZeroMeanActionPerformed(ActionEvent evt) {
        this.dtp.addTransform(new ZeroMeanTransform.ZeroMeanTransformFactory());
        this.jMenuCurTransforms.add(new JLabel(" Zero Mean "));
    }

    private void jItemTransPCAActionPerformed(ActionEvent evt) {
        String s = JOptionPane.showInputDialog(this.rootPane, "Please Specify the number of components for the transform", "PCA Transform", 3);
        try {
            int pcs = Integer.parseInt(s);
            if (pcs < 1) {
                throw new RuntimeException();
            }
            this.dtp.addTransform(new PCA.PCAFactory(pcs));
            this.jMenuCurTransforms.add(new JLabel(" PCA [" + pcs + "] "));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jItemTransWhitenedPCAActionPerformed(ActionEvent evt) {
        String s = JOptionPane.showInputDialog(this.rootPane, "Please Specify the number of components for the transform", "Whitened PCA Transform", 3);
        try {
            int pcs = Integer.parseInt(s);
            if (pcs < 1) {
                throw new RuntimeException();
            }
            this.dtp.addTransform(new WhitenedPCA.WhitenedPCATransformFactory(pcs));
            this.jMenuCurTransforms.add(new JLabel(" Whitened PCA [" + pcs + "] "));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jItemTransWhitenedZCAActionPerformed(ActionEvent evt) {
        this.dtp.addTransform(new WhitenedZCA.WhitenedZCATransformFactory());
        this.jMenuCurTransforms.add(new JLabel(" Whitened ZCA "));
    }

    private void jItemTransLinearActionPerformed(ActionEvent evt) {
        String s = JOptionPane.showInputDialog(this.rootPane, "Please specify the minimum and maximum range for the transform as \"min,max\" ", "Linear Transform", 3);
        try {
            String[] split = s.split(",");
            if (split.length != 2) {
                throw new RuntimeException();
            }
            double B = Double.parseDouble(split[0]);
            double A = Double.parseDouble(split[1]);
            this.dtp.addTransform(new LinearTransform.LinearTransformFactory(A, B));
            this.jMenuCurTransforms.add(new JLabel(" Linear [" + A + ", " + B + "] "));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jItemClearTransformsActionPerformed(ActionEvent evt) {
        this.dtp = new DataTransformProcess();
        this.jMenuCurTransforms.removeAll();
    }

    private void jMenuItemNumericHistroActionPerformed(ActionEvent evt) {
        this.dtp.addTransform(new NumericalToHistogram.NumericalToHistogramTransformFactory());
        this.jMenuCurTransforms.add(new JLabel("Numerical to Histogram"));
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainGUI().setVisible(true);
            }
        });
    }

    private void updateMenuPreductingClassItems() {
        this.jMenuPredictingClass.removeAll();
        if (this.data.getNumCategoricalVars() > 0) {
            ArrayList<JRadioButtonMenuItem> classSelectionOptions = new ArrayList<JRadioButtonMenuItem>(this.data.getNumCategoricalVars());
            for (int i = 0; i < this.data.getNumCategoricalVars(); ++i) {
                JRadioButtonMenuItem classButtonOption = new JRadioButtonMenuItem(this.data.getCategoryName(i));
                classButtonOption.setSelected(false);
                classSelectionOptions.add(classButtonOption);
            }
            ButtonGroup buttonGroup = new ButtonGroup();
            for (JRadioButtonMenuItem jrbmi : classSelectionOptions) {
                buttonGroup.add(jrbmi);
            }
            ((JRadioButtonMenuItem)classSelectionOptions.get(classSelectionOptions.size() - 1)).setSelected(true);
            for (JRadioButtonMenuItem jrbmi : classSelectionOptions) {
                this.jMenuPredictingClass.add(jrbmi);
            }
        }
    }
}

