/*
 * Decompiled with CFR 0.152.
 */
package jsat.guitool;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class LongProcessDialog
extends JDialog {
    private static final long serialVersionUID = -186028772859867338L;
    private JLabel messageLabel = new JLabel();
    private JLabel noteLabel = new JLabel();
    private JProgressBar progressBar;
    private JButton cancelButton = new JButton("Cancel");
    private volatile boolean canceled = false;
    private List<ActionListener> actions = new ArrayList<ActionListener>();

    public LongProcessDialog(Frame owner, String title) {
        super(owner, title, false);
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.setLayout(new BorderLayout());
        JPanel tmp = new JPanel(new FlowLayout());
        tmp.add(this.cancelButton);
        this.add((Component)tmp, "South");
        JPanel mainPanel = new JPanel(new GridLayout(3, 1));
        Font font = this.messageLabel.getFont();
        Font newFont = new Font(font.getName(), font.getStyle(), font.getSize() + 2);
        this.messageLabel.setFont(newFont);
        tmp = new JPanel(new FlowLayout());
        tmp.add(this.messageLabel);
        mainPanel.add(tmp);
        tmp = new JPanel(new FlowLayout());
        tmp.add(this.noteLabel);
        mainPanel.add(tmp);
        tmp = new JPanel(new FlowLayout());
        tmp.add(this.progressBar);
        mainPanel.add(tmp);
        this.add((Component)mainPanel, "Center");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LongProcessDialog.this.canceled = true;
                LongProcessDialog.this.setVisible(false);
                for (ActionListener al : LongProcessDialog.this.actions) {
                    al.actionPerformed(e);
                }
            }
        });
    }

    public void addCancleActionListener(ActionListener e) {
        this.actions.add(e);
    }

    public void setIndeterminate(boolean indeterminate) {
        this.progressBar.setIndeterminate(indeterminate);
    }

    public void setMessage(String message) {
        this.messageLabel.setText(message);
    }

    public void setNote(String note) {
        this.noteLabel.setText(note);
    }

    public void setMinimum(int i) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMinimum(i);
    }

    public void setMaximum(int i) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMaximum(i);
    }

    public void setValue(int i) {
        this.progressBar.setValue(i);
        if (this.progressBar.getValue() == this.progressBar.getMaximum()) {
            this.setVisible(false);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

