/*
 * Decompiled with CFR 0.152.
 */
package jsat.guitool;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jsat.distributions.ContinuousDistribution;

public class DistributionSelectionDialog
extends JDialog {
    private static final long serialVersionUID = 4685124905824599836L;
    ContinuousDistribution[] distributions;
    final JPanel variablePanel;
    final JComboBox jc;
    String[] vars;

    public DistributionSelectionDialog(Frame owner, String title, ContinuousDistribution[] distributions) {
        super(owner, title, true);
        this.distributions = distributions;
        JPanel panel = new JPanel(new BorderLayout());
        this.variablePanel = new JPanel(new GridLayout(1, 1));
        this.jc = new JComboBox<ContinuousDistribution>(distributions);
        this.jc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContinuousDistribution dist = (ContinuousDistribution)DistributionSelectionDialog.this.jc.getSelectedItem();
                DistributionSelectionDialog.this.vars = dist.getVariables();
                double[] defaultVals = dist.getCurrentVariableValues();
                DistributionSelectionDialog.this.variablePanel.removeAll();
                DistributionSelectionDialog.this.variablePanel.setLayout(new GridLayout(DistributionSelectionDialog.this.vars.length, 1));
                for (int i = 0; i < DistributionSelectionDialog.this.vars.length; ++i) {
                    String var = DistributionSelectionDialog.this.vars[i];
                    JFormattedTextField jt = new JFormattedTextField(defaultVals[i]);
                    jt.setBorder(BorderFactory.createTitledBorder(var));
                    DistributionSelectionDialog.this.variablePanel.add(jt);
                }
                DistributionSelectionDialog.this.variablePanel.revalidate();
            }
        });
        this.jc.setSelectedIndex(0);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DistributionSelectionDialog.this.setVisible(false);
            }
        });
        panel.add((Component)this.jc, "North");
        panel.add((Component)new JScrollPane(this.variablePanel), "Center");
        panel.add((Component)okButton, "South");
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(panel);
    }

    public ContinuousDistribution getDistribution() {
        this.setSize(300, 300);
        this.setVisible(true);
        if (this.vars == null) {
            return null;
        }
        int index = this.jc.getSelectedIndex();
        for (int i = 0; i < this.variablePanel.getComponentCount(); ++i) {
            this.distributions[index].setVariable(this.vars[i], Double.parseDouble(((JFormattedTextField)this.variablePanel.getComponent(i)).getText()));
        }
        return this.distributions[index].clone();
    }
}

