/*
 * Decompiled with CFR 0.152.
 */
package jsat.guitool;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jsat.DataSet;

public class DataSetSelection
extends JDialog {
    private static final long serialVersionUID = -2599749949210575182L;
    final String[] dataSelections;
    final String[] reasons;
    JComboBox[] boxs;

    public DataSetSelection(Frame parent, String title, DataSet dataSet, String[] reasons) {
        super(parent, title, true);
        this.dataSelections = new String[dataSet.getNumNumericalVars()];
        for (int i = 0; i < this.dataSelections.length; ++i) {
            this.dataSelections[i] = dataSet.getNumericName(i);
        }
        this.reasons = reasons;
        this.boxs = new JComboBox[reasons.length];
        JPanel optionPanel = new JPanel(new GridLayout(reasons.length, 1));
        JPanel fullPanel = new JPanel(new BorderLayout());
        for (int i = 0; i < reasons.length; ++i) {
            JComboBox<String> jc = new JComboBox<String>(this.dataSelections);
            jc.setBorder(BorderFactory.createTitledBorder(reasons[i]));
            this.boxs[i] = jc;
            optionPanel.add(jc);
        }
        fullPanel.add((Component)new JScrollPane(optionPanel), "Center");
        JButton closeButton = new JButton("Ok");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetSelection.this.setVisible(false);
            }
        });
        fullPanel.add((Component)closeButton, "South");
        this.setContentPane(fullPanel);
    }

    public int[] getSelections() {
        int[] selections = new int[this.reasons.length];
        this.pack();
        this.setVisible(true);
        for (int i = 0; i < this.reasons.length; ++i) {
            selections[i] = this.boxs[i].getSelectedIndex();
        }
        return selections;
    }
}

