/*
 * Decompiled with CFR 0.152.
 */
package jsat.guitool;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.ClassificationModelEvaluation;
import jsat.classifiers.Classifier;
import jsat.datatransform.DataTransformProcess;
import jsat.exceptions.FailedToFitException;
import jsat.graphing.ROCPlot;
import jsat.guitool.LongProcessDialog;
import jsat.guitool.ParameterPanel;
import jsat.parameters.Parameterized;
import jsat.utils.SystemInfo;

public class ClassifierCVEvaluation
extends JDialog {
    private static final long serialVersionUID = 1817759770295960277L;
    private ExecutorService threadPool;

    private static String timeString(long time) {
        DecimalFormat df = new DecimalFormat("0.####");
        String unit = " ms";
        double dTime = time;
        if (dTime > 1000.0) {
            dTime /= 1000.0;
            unit = " s";
            if (dTime > 120.0) {
                dTime /= 60.0;
                unit = " m";
                if (dTime > 120.0) {
                    dTime /= 60.0;
                    unit = " h";
                }
            }
        }
        return df.format(dTime) + unit;
    }

    public ClassifierCVEvaluation(final List<Classifier> classifiers, final List<String> classifierNames, final ClassificationDataSet dataset, Frame owner, String title, boolean modal, final DataTransformProcess dtp) {
        super(owner, title, modal);
        final boolean isBinaryProblem = dataset.getPredicting().getNumOfCategories() == 2;
        final LongProcessDialog pm = new LongProcessDialog(owner, "Performing Cross Validation");
        pm.setMinimum(0);
        pm.setMaximum(classifiers.size());
        pm.setMessage("Performing Cross Validation");
        pm.setNote("Note");
        pm.pack();
        pm.setSize(450, pm.getHeight());
        pm.setVisible(true);
        final ArrayList threadsCreated = new ArrayList();
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread toReturn = new Thread(r);
                toReturn.setDaemon(false);
                threadsCreated.add(toReturn);
                return toReturn;
            }
        };
        this.threadPool = Executors.newFixedThreadPool(SystemInfo.LogicalCores, threadFactory);
        final ArrayList resultPanels = new ArrayList();
        final SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                DecimalFormat df = new DecimalFormat("0.00000");
                ArrayList<ClassificationModelEvaluation> cmes = new ArrayList<ClassificationModelEvaluation>();
                for (int i = 0; i < classifiers.size() && !pm.isCanceled(); ++i) {
                    final int ip1 = i + 1;
                    try {
                        Classifier classifier = (Classifier)classifiers.get(i);
                        String name = (String)classifierNames.get(i);
                        CategoricalData predicting = dataset.getPredicting();
                        pm.setNote("Evaluating " + name);
                        ClassificationModelEvaluation cme = new ClassificationModelEvaluation(classifier, dataset, ClassifierCVEvaluation.this.threadPool);
                        if (isBinaryProblem) {
                            cme.keepPredictions(true);
                            cmes.add(cme);
                        }
                        if (dtp != null) {
                            cme.setDataTransformProcess(dtp);
                        }
                        try {
                            cme.evaluateCrossValidation(10);
                        }
                        catch (FailedToFitException ex) {
                            if (pm.isCanceled()) {
                                return null;
                            }
                            pm.setNote("Evaluating " + name + ", falling back to Single Threaded");
                            try {
                                cme = new ClassificationModelEvaluation(classifier, dataset);
                                cme.evaluateCrossValidation(10);
                            }
                            catch (Exception exexp) {
                                // empty catch block
                            }
                        }
                        if (pm.isCanceled()) {
                            return null;
                        }
                        JPanel panel = new JPanel(new BorderLayout());
                        double[][] confusionMatrix = cme.getConfusionMatrix();
                        Object[] columnNames = new String[predicting.getNumOfCategories() + 1];
                        Object[][] data = new Object[columnNames.length - 1][columnNames.length];
                        columnNames[0] = "Confusion Matrix";
                        for (int j = 0; j < data.length; ++j) {
                            String string = predicting.getOptionName(j);
                            columnNames[j + 1] = string;
                            data[j][0] = string;
                            for (int k = 1; k < data[j].length; ++k) {
                                data[j][k] = new Double(confusionMatrix[j][k - 1]);
                            }
                        }
                        panel.add((Component)new JScrollPane(new JTable(data, columnNames)), "Center");
                        Vector<String> listInfo = new Vector<String>();
                        listInfo.add("Error Rate: " + df.format(cme.getErrorRate()));
                        listInfo.add("Training Time: " + ClassifierCVEvaluation.timeString(cme.getTotalTrainingTime()));
                        listInfo.add("Classification Time: " + ClassifierCVEvaluation.timeString(cme.getTotalClassificationTime()));
                        JList jList = new JList(listInfo);
                        GridLayout layout = classifier instanceof Parameterized ? new GridLayout(2, 1) : new GridLayout(1, 1);
                        JPanel rightPanel = new JPanel(layout);
                        rightPanel.add(new JScrollPane(jList));
                        if (classifier instanceof Parameterized) {
                            JPanel sub = new JPanel();
                            ParameterPanel pp = new ParameterPanel((Parameterized)((Object)classifier));
                            pp.getjButtonOk().setVisible(false);
                            sub.add(pp);
                            Stack<JComponent> components = new Stack<JComponent>();
                            components.add(pp);
                            while (!components.isEmpty()) {
                                for (Component comp : ((JComponent)components.pop()).getComponents()) {
                                    comp.setEnabled(false);
                                    if (!(comp instanceof JComponent)) continue;
                                    components.add((JComponent)comp);
                                }
                            }
                            rightPanel.add(sub);
                        }
                        panel.add((Component)rightPanel, "East");
                        resultPanels.add(panel);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                pm.setValue(ip1);
                            }
                        });
                        continue;
                    }
                    catch (Exception ex) {
                        if (pm.isCanceled()) {
                            return null;
                        }
                        JPanel jp = new JPanel(new GridLayout(1, 1));
                        JTextArea jta = new JTextArea("The folloing error occured:\n" + ex.getMessage());
                        jp.add(jta);
                        resultPanels.add(jp);
                    }
                }
                if (isBinaryProblem) {
                    ROCPlot rocPlot = new ROCPlot(new ArrayList<String>(classifierNames), cmes);
                    classifierNames.add("ROC Curves");
                    JPanel jp = new JPanel(new GridLayout(1, 1));
                    jp.add(rocPlot);
                    resultPanels.add(jp);
                }
                return null;
            }

            @Override
            protected void done() {
                if (pm.isCanceled()) {
                    ClassifierCVEvaluation.this.setVisible(false);
                    ClassifierCVEvaluation.this.threadPool.shutdownNow();
                    return;
                }
                JTabbedPane jTabbedPane = new JTabbedPane();
                for (int i = 0; i < classifierNames.size(); ++i) {
                    jTabbedPane.add((String)classifierNames.get(i), (Component)resultPanels.get(i));
                }
                ClassifierCVEvaluation.this.setLayout(new GridLayout(1, 1));
                ClassifierCVEvaluation.this.add(jTabbedPane);
                ClassifierCVEvaluation.this.pack();
                ClassifierCVEvaluation.this.setVisible(true);
                ClassifierCVEvaluation.this.threadPool.shutdown();
            }
        };
        pm.addCancleActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                worker.cancel(true);
                ClassifierCVEvaluation.this.threadPool.shutdownNow();
                for (Thread t : threadsCreated) {
                    if (!t.isAlive()) continue;
                    try {
                        t.stop();
                    }
                    catch (Exception ex) {}
                }
            }
        });
        worker.execute();
    }
}

