/*
 * Decompiled with CFR 0.152.
 */
package jsat.graphing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.DataPoint;
import jsat.graphing.Graph2D;
import jsat.graphing.ProgressPanel;
import jsat.linear.DenseVector;
import jsat.linear.Vec;
import jsat.math.Function;
import jsat.regression.RegressionDataSet;
import jsat.regression.Regressor;

public class ScatterPlot
extends Graph2D {
    private static final long serialVersionUID = -2533942800053058839L;
    private Vec xValues;
    private Vec yValues;
    private Function regressionFunction;

    public ScatterPlot(Vec xValues, Vec yValues) {
        this(xValues, yValues, null);
    }

    public ScatterPlot(Vec xValues, Vec yValues, Regressor regressor) {
        super(xValues.min(), xValues.max(), yValues.min(), yValues.max());
        if (xValues.length() != yValues.length()) {
            throw new ArithmeticException("Data sets must have the same length");
        }
        this.xValues = xValues;
        this.yValues = yValues;
        if (regressor == null) {
            this.regressionFunction = null;
        } else {
            RegressionDataSet rds = new RegressionDataSet(1, new CategoricalData[0]);
            final int[] catVals = new int[]{};
            final CategoricalData[] catData = new CategoricalData[]{};
            for (int i = 0; i < xValues.length(); ++i) {
                rds.addDataPoint(new DataPoint(DenseVector.toDenseVec(xValues.get(i)), catVals, catData), yValues.get(i));
            }
            final Regressor myReg = regressor.clone();
            myReg.train(rds);
            this.regressionFunction = new Function(){
                private static final long serialVersionUID = -2078175037671332385L;

                @Override
                public double f(double ... x) {
                    return this.f(DenseVector.toDenseVec(x));
                }

                @Override
                public double f(Vec x) {
                    return myReg.regress(new DataPoint(x, catVals, catData));
                }
            };
        }
    }

    @Override
    protected void paintWork(Graphics g, int imageWidth, int imageHeight, ProgressPanel pp) {
        super.paintWork(g, imageWidth, imageHeight, pp);
        Graphics2D g2 = (Graphics2D)g;
        if (pp != null) {
            pp.getjProgressBar().setIndeterminate(false);
            pp.getjProgressBar().setMaximum(this.xValues.length());
        }
        g2.setColor(Color.red);
        for (int i = 0; i < this.xValues.length(); ++i) {
            this.drawPoint(g2, Graph2D.PointShape.CIRCLE, this.xValues.get(i), this.yValues.get(i), imageWidth, imageHeight, 6.0, false);
            if (pp == null) continue;
            pp.getjProgressBar().setValue(i + 1);
        }
        if (this.regressionFunction != null) {
            g2.setColor(Color.BLUE);
            this.drawFunction(g2, this.regressionFunction);
        }
    }

    public void setRegressionFunction(Function regressionFunction) {
        this.regressionFunction = regressionFunction;
    }

    public Function getRegressionFunction() {
        return this.regressionFunction;
    }
}

