/*
 * Decompiled with CFR 0.152.
 */
package jsat.graphing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import jsat.graphing.Graph2D;
import jsat.graphing.ProgressPanel;

public class ReachabilityPlot
extends Graph2D {
    private static final long serialVersionUID = -5224740514692200878L;
    private double[] reachability;
    private double max = -1.7976931348623157E308;

    public ReachabilityPlot(double[] reachability) {
        super(0.0, 1.0, 0.0, 1.0);
        this.reachability = reachability;
        for (double d : reachability) {
            if (Double.isInfinite(d)) continue;
            this.max = Math.max(d, this.max);
        }
        this.setYMax(this.max);
        this.setYAxisTtile("Reachability Distance");
        this.setXAxisTtile("Reachability Order");
    }

    @Override
    protected void paintWork(Graphics g, int imageWidth, int imageHeight, ProgressPanel pp) {
        super.paintWork(g, imageWidth, imageHeight, pp);
        g.setColor(Color.BLACK);
        int H = imageHeight - this.getPadding() * 2;
        int thickness = Math.max((int)Math.floor((double)imageWidth / (double)this.reachability.length), 1);
        for (int i = 0; i < this.reachability.length; ++i) {
            int too = Double.isInfinite(this.reachability[i]) ? H : (int)((double)H * (this.reachability[i] / this.max));
            g.fillRect(i * thickness + this.getPadding(), H - too + this.getPadding(), thickness, too);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.reachability.length + this.getPadding() * 4, 400);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.reachability.length + this.getPadding() * 2 + 2, 100);
    }
}

