/*
 * Decompiled with CFR 0.152.
 */
package jsat.graphing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import jsat.distributions.ContinuousDistribution;
import jsat.graphing.Graph2D;
import jsat.graphing.ProgressPanel;
import jsat.linear.Vec;
import jsat.math.Function;

public class QQPlotDistribution
extends Graph2D {
    private static final long serialVersionUID = 9156814937052075799L;
    private ContinuousDistribution cd;
    private Vec yData;
    private double[] xData;

    public QQPlotDistribution(ContinuousDistribution cd, Vec data) {
        super(0.0, 0.0, 0.0, 0.0);
        this.cd = cd;
        this.yData = data.sortedCopy();
        this.xData = new double[this.yData.length()];
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (int i = 0; i < this.yData.length(); ++i) {
            double v = ((double)i + 1.0 - 0.375) / ((double)this.yData.length() + 0.25);
            double x = cd.invCdf(v);
            min = Math.min(x, min);
            max = Math.max(x, max);
            this.xData[i] = x;
        }
        min = Math.min(this.yData.get(0), min);
        max = Math.max(this.yData.max(), max);
        this.setXMin(min);
        this.setXMax(max);
        this.setYMin(min);
        this.setYMax(max);
        this.setXAxisTtile(cd.getDescriptiveName());
    }

    @Override
    protected void paintWork(Graphics g, int imageWidth, int imageHeight, ProgressPanel pp) {
        super.paintWork(g, imageWidth, imageHeight, pp);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.red);
        for (int i = 0; i < this.yData.length(); ++i) {
            this.drawPoint(g2, Graph2D.PointShape.CIRCLE, this.xData[i], this.yData.get(i), imageWidth, imageHeight, 6.0, false);
        }
        g.setColor(Color.BLUE);
        this.drawFunction(g2, new Function(){
            private static final long serialVersionUID = -341232144243738477L;

            @Override
            public double f(double ... x) {
                return x[0];
            }

            @Override
            public double f(Vec x) {
                return x.get(0);
            }
        });
    }
}

