/*
 * Decompiled with CFR 0.152.
 */
package jsat.graphing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import jsat.graphing.Graph2D;
import jsat.graphing.ProgressPanel;
import jsat.linear.Vec;
import jsat.math.Function;

public class QQPlotData
extends Graph2D {
    private static final long serialVersionUID = -6064799999519303006L;
    private Vec yData;
    private Vec xData;

    public QQPlotData(Vec xData, Vec yData) {
        super(0.0, 0.0, 0.0, 0.0);
        if (xData.length() != yData.length()) {
            throw new ArithmeticException("Data sets must be the same size");
        }
        this.yData = yData.sortedCopy();
        this.xData = xData.sortedCopy();
        double min = Math.min(this.yData.min(), this.xData.min());
        double max = Math.max(this.yData.max(), this.xData.max());
        this.setXMin(min);
        this.setXMax(max);
        this.setYMin(min);
        this.setYMax(max);
    }

    @Override
    protected void paintWork(Graphics g, int imageWidth, int imageHeight, ProgressPanel pp) {
        super.paintWork(g, imageWidth, imageHeight, pp);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.red);
        for (int i = 0; i < this.yData.length(); ++i) {
            this.drawPoint(g2, Graph2D.PointShape.CIRCLE, this.xData.get(i), this.yData.get(i), imageWidth, imageHeight, 6.0, false);
        }
        g.setColor(Color.BLUE);
        this.drawFunction(g2, new Function(){
            private static final long serialVersionUID = -8192738423385782080L;

            @Override
            public double f(double ... x) {
                return x[0];
            }

            @Override
            public double f(Vec x) {
                return x.get(0);
            }
        });
    }
}

