/*
 * Decompiled with CFR 0.152.
 */
package jsat.graphing;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import jsat.DataSet;
import jsat.classifiers.ClassificationDataSet;
import jsat.graphing.Graph2D;
import jsat.graphing.ProgressPanel;
import jsat.linear.Vec;

public class ParallelCoordinatesPlot
extends Graph2D {
    private static final long serialVersionUID = 8293545570354260288L;
    private DataSet dataSet;
    private double[] scales;
    private double[] offsets;
    private List<Color> categoryColors;

    public ParallelCoordinatesPlot(DataSet dataSet) {
        super(0.0, 1.0, 0.0, 1.0);
        this.dataSet = dataSet;
        this.setDrawMarkers(false);
        this.scales = new double[dataSet.getNumNumericalVars()];
        this.offsets = new double[this.scales.length];
        for (int i = 0; i < dataSet.getNumNumericalVars(); ++i) {
            Vec v = dataSet.getNumericColumn(i);
            this.offsets[i] = v.min();
            this.scales[i] = v.max() - this.offsets[i];
        }
        this.categoryColors = new ArrayList<Color>();
        if (dataSet instanceof ClassificationDataSet) {
            ClassificationDataSet cds = (ClassificationDataSet)dataSet;
            float colorFactor = 1.0f / (float)cds.getClassSize();
            for (int i = 0; i < cds.getClassSize(); ++i) {
                Color c = Color.getHSBColor((float)i * colorFactor, 0.95f, 0.7f);
                this.categoryColors.add(c);
            }
        } else {
            this.categoryColors.add(Color.BLUE);
        }
    }

    @Override
    protected void paintWork(Graphics g, int imageWidth, int imageHeight, ProgressPanel pp) {
        int i;
        super.paintWork(g, imageWidth, imageHeight, pp);
        double factor = 1.0 / (double)(this.dataSet.getNumNumericalVars() - 1);
        g.setColor(Color.BLACK);
        double weigthRange = imageWidth - this.PAD * 2;
        int[] xPixels = new int[this.dataSet.getNumNumericalVars()];
        for (i = 0; i < this.dataSet.getNumNumericalVars(); ++i) {
            xPixels[i] = (int)((double)this.PAD + weigthRange * (factor * (double)i));
            g.drawLine(xPixels[i], this.toYCord(0.0, imageHeight), xPixels[i], this.toYCord(1.0, imageHeight));
        }
        g.setColor(this.categoryColors.get(0));
        for (i = 0; i < this.dataSet.getSampleSize(); ++i) {
            if (this.dataSet instanceof ClassificationDataSet) {
                g.setColor(this.categoryColors.get(((ClassificationDataSet)this.dataSet).getDataPointCategory(i)));
            }
            Vec v = this.dataSet.getDataPoint(i).getNumericalValues();
            for (int j = 0; j < v.length() - 1; ++j) {
                g.drawLine(xPixels[j], this.toYCord((v.get(j) - this.offsets[j]) / this.scales[j], imageHeight), xPixels[j + 1], this.toYCord((v.get(j + 1) - this.offsets[j + 1]) / this.scales[j + 1], imageHeight));
            }
        }
        g.setColor(Color.BLACK);
        FontMetrics fm = g.getFontMetrics();
        int y = fm.getHeight();
        for (int i2 = 0; i2 < this.dataSet.getNumNumericalVars(); ++i2) {
            String catName = this.dataSet.getNumericName(i2);
            int x = xPixels[i2] - fm.stringWidth(catName) / 2;
            g.drawString(catName, x, y);
        }
    }
}

