/*
 * Decompiled with CFR 0.152.
 */
package jsat.graphing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import jsat.graphing.Graph2D;
import jsat.linear.Vec;

public class Histogram
extends Graph2D {
    private static final long serialVersionUID = 4048138870310152844L;
    Vec data;
    int[] frequency;
    final double lowVal;
    final double highVal;

    public Histogram(Vec data) {
        this((int)Math.sqrt(data.length()), data);
    }

    public Histogram(int boxes, Vec data) {
        super(data.min(), data.max(), 0.0, data.length());
        this.data = data.sortedCopy();
        this.lowVal = data.min();
        this.highVal = data.max();
        this.setBoxes(boxes);
    }

    private void setBoxes(int n) {
        this.frequency = new int[n];
        int mostFrequent = 0;
        double width = (this.highVal - this.lowVal) / (double)n;
        int i = 0;
        for (int index = 0; index < this.frequency.length && i < this.data.length(); ++index) {
            while (i < this.data.length() && (double)(index + 1) * width >= this.data.get(i) - this.lowVal) {
                int n2 = index;
                this.frequency[n2] = this.frequency[n2] + 1;
                ++i;
            }
        }
        for (i = 0; i < this.frequency.length; ++i) {
            mostFrequent = Math.max(mostFrequent, this.frequency[i]);
        }
        this.setYMax(mostFrequent + 2);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        double range = (this.highVal - this.lowVal) / (double)this.frequency.length;
        int width = this.toXCord(this.lowVal + range) - this.toXCord(this.lowVal);
        g2.setColor(Color.red);
        for (int i = 0; i < this.frequency.length; ++i) {
            g2.drawRect(this.toXCord(this.lowVal) + i * width, this.toYCord(this.frequency[i]), width, this.toYCord(0.0) - this.toYCord(this.frequency[i]));
        }
    }
}

