/*
 * Decompiled with CFR 0.152.
 */
package jsat.graphing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import jsat.graphing.ProgressPanel;
import jsat.math.Function;

public class Graph2D
extends JComponent {
    private static final long serialVersionUID = -3915414272424355156L;
    protected double xMin;
    protected double xMax;
    protected double yMin;
    protected double yMax;
    protected int PAD;
    protected String xAxisTtile = "X Axis";
    protected String yAxisTtile = "Y Axis";
    protected volatile BufferedImage currentImage;
    private boolean forceRedraw = false;
    private boolean drawMarkers = true;
    protected volatile SwingWorker<BufferedImage, Object> drawWorker;
    private static final DecimalFormat sigFormat = new DecimalFormat("0.##E0");

    protected void forceRedraw() {
        this.forceRedraw = true;
    }

    public Graph2D(double xMin, double xMax, double yMin, double yMax) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
        this.PAD = -1;
        this.addMouseListener(new MouseAdapter(){

            private void popup(MouseEvent e) {
                JPopupMenu popup = Graph2D.this.getPopupMenu();
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    this.popup(me);
                }
            }

            @Override
            public void mousePressed(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    this.popup(me);
                }
            }
        });
    }

    public void setDrawMarkers(boolean drawMarkers) {
        this.forceRedraw = this.drawMarkers != drawMarkers;
        this.drawMarkers = drawMarkers;
    }

    public boolean hasDrawMarkers() {
        return this.drawMarkers;
    }

    public void setYAxisTtile(String yAxisTtile) {
        this.yAxisTtile = yAxisTtile;
    }

    public void setXAxisTtile(String xAxisTtile) {
        this.xAxisTtile = xAxisTtile;
    }

    public void setXMin(double xMin) {
        this.xMin = xMin;
    }

    public void setXMax(double xMax) {
        this.xMax = xMax;
    }

    public void setYMin(double yMin) {
        this.yMin = yMin;
    }

    public void setYMax(double yMax) {
        this.yMax = yMax;
    }

    public void setPadding(int p) {
        this.PAD = p;
    }

    public int getPadding() {
        return this.PAD;
    }

    public void toSquareProprotion() {
        double w = this.getWidth() - this.PAD * 2;
        double h = this.getHeight() - this.PAD * 2;
        double xRange = this.xMax - this.xMin;
        double yRange = this.yMax - this.yMin;
        double xRw = xRange / w;
        double yRh = xRange / h;
        if (xRange / w < yRange / h) {
            double toAdd = (yRh * w - xRange) / 2.0;
            this.xMax += toAdd;
            this.xMin -= toAdd;
        } else if (xRange / w > yRange / h) {
            double toAdd = (xRw * h - yRange) / 2.0;
            this.yMax += toAdd;
            this.yMin -= toAdd;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        String drawingMessage = "Rendering Update...";
        FontMetrics fm = g.getFontMetrics();
        if (this.currentImage != null) {
            if (this.currentImage.getWidth() != this.getWidth() || this.currentImage.getHeight() != this.getHeight() || this.forceRedraw) {
                this.forceRedraw = false;
                if (this.drawWorker == null) {
                    this.createBackgroundImage();
                }
                g.drawImage(this.currentImage, 0, 0, this.getWidth(), this.getHeight(), null);
                g.drawString("Rendering Update...", 3, this.getHeight() - fm.getHeight() / 2);
            } else {
                g.drawImage(this.currentImage, 0, 0, null);
            }
        } else if (this.currentImage == null) {
            if (this.drawWorker == null) {
                this.createBackgroundImage();
            }
            g.drawString("Rendering Update...", this.getWidth() / 2 - fm.stringWidth("Rendering Update...") / 2, this.getHeight() / 2 - fm.getHeight() / 2);
        }
    }

    private void createBackgroundImage() {
        this.drawWorker = new SwingWorker<BufferedImage, Object>(){

            @Override
            protected BufferedImage doInBackground() throws Exception {
                BufferedImage newImage = new BufferedImage(Graph2D.this.getWidth(), Graph2D.this.getHeight(), 2);
                Graphics g = newImage.getGraphics();
                Graph2D.this.paintWork(g, newImage.getWidth(), newImage.getHeight(), null);
                return newImage;
            }

            @Override
            protected void done() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Graph2D.this.currentImage = (BufferedImage)this.get();
                            Graph2D.this.drawWorker = null;
                            Graph2D.this.revalidate();
                            Graph2D.this.repaint();
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(null, ex.getMessage());
                        }
                    }
                });
            }
        };
        this.drawWorker.execute();
    }

    protected void paintWork(Graphics g, int imageWidth, int imageHeight, ProgressPanel pp) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = imageWidth;
        int h = imageHeight;
        FontMetrics fm = g2.getFontMetrics();
        if (this.PAD == 0) {
            return;
        }
        if (this.PAD == -1) {
            this.PAD = (fm.getHeight() + 2) * 2;
        }
        g2.setColor(Color.black);
        g2.draw(new Line2D.Double(this.PAD, this.PAD, this.PAD, h - this.PAD));
        g2.draw(new Line2D.Double(this.PAD, h - this.PAD, w - this.PAD, h - this.PAD));
        if (this.drawMarkers) {
            for (int x = this.PAD * 2; x <= w - this.PAD * 2; x += (w - this.PAD * 2) / 4) {
                double xVal = this.toXVal(x, imageWidth);
                String xValString = Graph2D.displayValue(xVal);
                g2.drawString(xValString, x - fm.stringWidth(xValString) / 2, h - this.PAD + fm.getHeight());
            }
        }
        if (this.xAxisTtile != null && !this.xAxisTtile.equals("")) {
            g2.drawString(this.xAxisTtile, (w - this.PAD) / 2 - fm.stringWidth(this.xAxisTtile) / 2, h - this.PAD + fm.getHeight() * 2 + 2);
        }
        AffineTransform at = new AffineTransform();
        at.setToRotation(-1.5707963267948966, 0.0, 0.0);
        Font origFont = this.getFont();
        if (origFont == null) {
            origFont = new Font("SansSerif", 0, 12);
        }
        Font der = origFont.deriveFont(at);
        g2.setFont(der);
        if (this.drawMarkers) {
            for (int y = this.PAD * 2; y <= h - this.PAD * 2; y += (h - this.PAD * 2) / 4) {
                double yVal = this.toYVal(y, imageHeight);
                String yValString = Graph2D.displayValue(yVal);
                g2.drawString(yValString, fm.getHeight() * 2, y + fm.getHeight() / 2);
            }
        }
        if (this.yAxisTtile != null && !this.yAxisTtile.equals("")) {
            g2.drawString(this.yAxisTtile, fm.getAscent(), (h + this.PAD) / 2 + fm.getHeight());
        }
        g2.setFont(origFont);
    }

    private static String displayValue(double x) {
        String tmp = Double.toString(x);
        if (tmp.length() <= 4) {
            return tmp;
        }
        if (x < 99.0 && x >= -99.0) {
            return tmp.substring(0, 5);
        }
        if (x > 0.0 && x < 9999.0) {
            return tmp.substring(0, 5);
        }
        if (x < 0.0 && x > -9999.0 && tmp.length() > 5) {
            return tmp.substring(0, 6);
        }
        return sigFormat.format(x);
    }

    public int toXCord(double x) {
        return this.toXCord(x, this.getWidth());
    }

    public int toXCord(double x, int width) {
        double scale = (double)(width - 2 * this.PAD) / (this.xMax - this.xMin);
        return (int)Math.round((x -= this.xMin) * scale) + this.PAD;
    }

    public double toXVal(int x) {
        return this.toXVal(x, this.getWidth());
    }

    public double toXVal(int x, int width) {
        double scale = (double)(width - 2 * this.PAD) / (this.xMax - this.xMin);
        return (double)(x -= this.PAD) / scale + this.xMin;
    }

    public double toYVal(int y) {
        return this.toYVal(y, this.getHeight());
    }

    public double toYVal(int y, int height) {
        y -= this.PAD;
        y = height - 2 * this.PAD - y;
        double scale = (double)(height - 2 * this.PAD) / (this.yMax - this.yMin);
        return (double)y / scale + this.yMin;
    }

    public int toYCord(double y) {
        return this.toYCord(y, this.getHeight());
    }

    public int toYCord(double y, int height) {
        double scale = (double)(height - 2 * this.PAD) / (this.yMax - this.yMin);
        return height - (int)Math.round((y -= this.yMin) * scale) - this.PAD;
    }

    public void scaleCords(double scale) {
        if (scale <= 0.0 || Double.isInfinite(scale) || Double.isNaN(scale)) {
            throw new ArithmeticException("Invalid scale " + scale);
        }
        double xRange = Math.abs(this.xMax - this.xMin);
        double yRange = Math.abs(this.yMax - this.yMin);
        double xShave = (xRange * scale - xRange) / 2.0;
        double yShave = (yRange * scale - yRange) / 2.0;
        this.setXMax(this.xMax + xShave);
        this.setXMin(this.xMin - xShave);
        this.setYMax(this.yMax + yShave);
        this.setYMin(this.yMin - yShave);
    }

    protected void drawFunction(Graphics2D g, Function func) {
        double lastX = this.toXVal(this.PAD + 1);
        double lastY = func.f(lastX);
        for (int i = this.PAD + 2; i < this.getWidth() - this.PAD; i += 4) {
            double x = this.toXVal(i);
            double y = func.f(x);
            g.drawLine(this.toXCord(lastX), this.toYCord(lastY), this.toXCord(x), this.toYCord(y));
            lastX = x;
            lastY = y;
        }
    }

    protected void drawPoint(Graphics2D g2, PointShape pointShape, double xPos, double yPos, double size, boolean fill) {
        Shape shape = null;
        if (pointShape == PointShape.CIRCLE) {
            shape = new Ellipse2D.Double(xPos, yPos, size, size);
        } else if (pointShape == PointShape.SQUARE) {
            shape = new Rectangle2D.Double(xPos, yPos, size, size);
        } else if (pointShape == PointShape.TRIANGLE) {
            double s = size / 2.0;
            GeneralPath path = new GeneralPath(1);
            path.moveTo(s + xPos, s + yPos - s);
            path.lineTo(s + xPos + s, s + yPos + s);
            path.lineTo(s + xPos - s, s + yPos + s);
            path.closePath();
            shape = path;
        }
        if (fill) {
            g2.fill(shape);
        } else {
            g2.draw(shape);
        }
    }

    protected void drawPoint(Graphics2D g2, PointShape pointShape, double xValue, double yValue, int width, int height, double size, boolean fill) {
        double xPos = (double)this.toXCord(xValue, width) - size / 2.0;
        double yPos = (double)this.toYCord(yValue, height) - size / 2.0;
        this.drawPoint(g2, pointShape, xPos, yPos, size, fill);
    }

    protected void drawKey(Graphics2D g2, int pos, List<String> names, List<Color> colors) {
        this.drawKey(g2, pos, names, colors, null);
    }

    protected void drawKey(Graphics2D g2, int pos, List<String> names, List<Color> colors, List<PointShape> shapes) {
        int startY;
        int startX;
        Font font = g2.getFont();
        int width = 0;
        for (int i = 0; i < names.size(); ++i) {
            width = Math.max(width, g2.getFontMetrics().stringWidth(names.get(i)));
        }
        width += 2 + this.getPadding();
        if (pos == 0) {
            startX = this.getPadding();
            startY = this.getPadding();
        } else if (pos == 1) {
            startX = this.getWidth() - this.getPadding() - width;
            startY = this.getPadding();
        } else if (pos == 2) {
            startX = this.getPadding();
            startY = this.getHeight() - this.getPadding() * 2 - (font.getSize() + 2) * names.size() + this.getPadding() / 2;
        } else {
            startX = this.getWidth() - this.getPadding() - width;
            startY = this.getHeight() - this.getPadding() * 2 - (font.getSize() + 2) * names.size() + this.getPadding() / 2;
        }
        Color origColor = g2.getColor();
        g2.setColor(Color.WHITE);
        g2.fillRect(startX, startY, width, (font.getSize() + 2) * names.size() + this.getPadding() / 2);
        g2.setColor(origColor);
        g2.drawRect(startX, startY, width, (font.getSize() + 2) * names.size() + this.getPadding() / 2);
        for (int i = 0; i < names.size(); ++i) {
            g2.setColor(colors.get(i));
            int xPos = startX + this.getPadding() * 1 / 2;
            int yPos = startY + (i + 1) * (font.getSize() + 2);
            g2.drawString(names.get(i), xPos, yPos);
            if (shapes == null) continue;
            this.drawPoint(g2, shapes.get(i), (double)xPos - 9.0, yPos - 9, 6.0, false);
        }
    }

    protected JPopupMenu getPopupMenu() {
        JPopupMenu menu = new JPopupMenu("Options");
        JMenuItem makeSquareItem = new JMenuItem("Make Proprotional");
        makeSquareItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Graph2D.this.toSquareProprotion();
                Graph2D.this.forceRedraw();
                Graph2D.this.invalidate();
                Graph2D.this.revalidate();
                Graph2D.this.repaint();
            }
        });
        menu.add(makeSquareItem);
        JMenuItem saveAsImage = new JMenuItem("Render to File");
        saveAsImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String input = JOptionPane.showInputDialog(Graph2D.this.getParent(), "Enter the width and height to use", "600, 600");
                if (input == null || !input.matches("[0-9]+,\\s*[0-9]+")) {
                    return;
                }
                String[] splt = input.split(",");
                final int width = Integer.parseInt(splt[0].trim());
                final int height = Integer.parseInt(splt[1].trim());
                JFileChooser jfc = new JFileChooser();
                int returnVal = jfc.showSaveDialog(Graph2D.this.getParent());
                if (returnVal == 0) {
                    final File file = jfc.getSelectedFile();
                    final BufferedImage img = new BufferedImage(width, height, 2);
                    final ProgressPanel pp = new ProgressPanel("Rendering Image to file", "");
                    final JDialog dialog = new JDialog();
                    dialog.setContentPane(pp);
                    dialog.pack();
                    dialog.setVisible(true);
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Graph2D.this.paintWork(img.createGraphics(), width, height, pp);
                            dialog.setVisible(false);
                            try {
                                ImageIO.write((RenderedImage)img, "png", file);
                            }
                            catch (IOException ex) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(Graph2D.this.getParent(), "An error occured when trying to save the image", "Error", 0);
                                    }
                                });
                            }
                        }
                    });
                    t.start();
                }
            }
        });
        menu.add(saveAsImage);
        return menu;
    }

    public void renderToFile(File file, int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 2);
        this.paintWork(img.createGraphics(), width, height, null);
        try {
            ImageIO.write((RenderedImage)img, "png", file);
        }
        catch (IOException ex) {
            Logger.getLogger(Graph2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static enum PointShape {
        CIRCLE,
        SQUARE,
        TRIANGLE;

    }
}

