/*
 * Decompiled with CFR 0.152.
 */
package jsat.graphing;

import java.awt.Color;
import java.awt.Graphics2D;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.Classifier;
import jsat.classifiers.DataPoint;
import jsat.graphing.CategoryPlot;
import jsat.graphing.ProgressPanel;
import jsat.linear.DenseVector;

public class ClassificationPlot
extends CategoryPlot {
    private static final long serialVersionUID = -5960348716104033016L;
    private Classifier classifier;
    private int resolution = 4;
    private boolean hardBoundaries = true;

    public ClassificationPlot(ClassificationDataSet dataSet, Classifier classifier) {
        super(dataSet);
        this.classifier = classifier;
    }

    public void setResolution(int resolution) {
        if (resolution > 0) {
            this.resolution = resolution;
        }
        this.forceRedraw();
    }

    public void setHardBoundaries(boolean hardBoundaries) {
        if (this.hardBoundaries == hardBoundaries) {
            return;
        }
        this.hardBoundaries = hardBoundaries;
        this.forceRedraw();
    }

    public boolean isHardBoundaries() {
        return this.hardBoundaries;
    }

    public int getResolution() {
        return this.resolution;
    }

    @Override
    protected void drawPoints(Graphics2D g2, int imageWidth, int imageHeight, ProgressPanel pp) {
        int[] noCatVals = new int[]{};
        CategoricalData[] noCatData = new CategoricalData[]{};
        double full = (imageWidth - this.PAD * 2) / this.resolution * (imageHeight - this.PAD * 2) / this.resolution;
        if (pp != null) {
            pp.setNote("Computing Boundry");
            pp.getjProgressBar().setMaximum((int)Math.ceil(full));
            pp.getjProgressBar().setIndeterminate(false);
        }
        for (int i = this.PAD + 1; i < imageWidth - this.PAD; i += this.resolution) {
            for (int j = this.PAD + 1; j < imageHeight - this.PAD; j += this.resolution) {
                CategoricalResults cr = this.classifier.classify(new DataPoint(DenseVector.toDenseVec(this.toXVal(i, imageWidth), this.toYVal(j, imageHeight)), noCatVals, noCatData));
                if (cr.getProb(cr.mostLikely()) < 1.0E-17) continue;
                if (this.hardBoundaries) {
                    int crClass = cr.mostLikely();
                    g2.setColor(this.getCategoryColor(crClass).brighter());
                } else {
                    float R = 0.0f;
                    float G = 0.0f;
                    float B = 0.0f;
                    for (int z = 0; z < cr.size(); ++z) {
                        Color c = this.getCategoryColor(z).brighter();
                        R = (float)((double)R + (double)c.getRed() * cr.getProb(z));
                        G = (float)((double)G + (double)c.getGreen() * cr.getProb(z));
                        B = (float)((double)B + (double)c.getBlue() * cr.getProb(z));
                    }
                    g2.setColor(new Color(R / 256.0f, G / 256.0f, B / 256.0f));
                }
                g2.fillRect(i, j, this.resolution, this.resolution);
                if (pp == null) continue;
                double cur = (imageWidth - this.PAD * 2) * i / this.resolution + (j - this.PAD) / this.resolution;
                pp.getjProgressBar().setValue((int)cur);
            }
        }
        super.drawPoints(g2, imageWidth, imageHeight, pp);
    }
}

