/*
 * Decompiled with CFR 0.152.
 */
package jsat.graphing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.ClassificationDataSet;
import jsat.graphing.Graph2D;
import jsat.graphing.ProgressPanel;
import jsat.linear.Vec;

public class CategoryPlot
extends Graph2D {
    private static final long serialVersionUID = -6193861413284802713L;
    private List<Color> categoryColors;
    private Vec xVals;
    private Vec yVals;
    private int[] category;
    private String[] names;
    private Graph2D.PointShape[] shapes;
    private double pointSize = 6.0;
    private boolean fillPoints = false;

    public CategoryPlot(ClassificationDataSet dataSet) {
        super(0.0, 1.0, 0.0, 1.0);
        int i;
        if (dataSet.getNumNumericalVars() != 2) {
            throw new ArithmeticException("Can not perform scatter plot on " + dataSet.getNumNumericalVars() + " variables");
        }
        CategoricalData categories = dataSet.getPredicting();
        this.names = new String[categories.getNumOfCategories()];
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            this.names[i2] = categories.getOptionName(i2);
        }
        this.categoryColors = new ArrayList<Color>(dataSet.getClassSize());
        this.shapes = new Graph2D.PointShape[dataSet.getClassSize()];
        float colorFactor = 1.0f / (float)dataSet.getClassSize();
        Graph2D.PointShape[] shapeOptions = Graph2D.PointShape.values();
        int curShape = 0;
        for (i = 0; i < dataSet.getClassSize(); ++i) {
            Color c = Color.getHSBColor((float)i * colorFactor, 0.95f, 0.7f);
            this.categoryColors.add(c);
            this.shapes[i] = shapeOptions[curShape];
            curShape = (curShape + 1) % shapeOptions.length;
        }
        this.xVals = dataSet.getNumericColumn(0);
        this.yVals = dataSet.getNumericColumn(1);
        this.setXMin(this.xVals.min());
        this.setXMax(this.xVals.max());
        this.setYMin(this.yVals.min());
        this.setYMax(this.yVals.max());
        this.category = new int[dataSet.getSampleSize()];
        for (i = 0; i < this.category.length; ++i) {
            this.category[i] = dataSet.getDataPointCategory(i);
        }
    }

    @Override
    protected void paintWork(Graphics g, int imageWidth, int imageHeight, ProgressPanel pp) {
        super.paintWork(g, imageWidth, imageHeight, pp);
        Graphics2D g2 = (Graphics2D)g;
        this.drawPoints(g2, imageWidth, imageHeight, pp);
        this.drawKey(g2, 0, Arrays.asList(this.names), this.categoryColors, Arrays.asList(this.shapes));
    }

    protected void drawPoints(Graphics2D g2, int width, int height, ProgressPanel pp) {
        if (pp != null) {
            pp.getjProgressBar().setIndeterminate(false);
            pp.getjProgressBar().setMaximum(this.category.length);
        }
        for (int i = 0; i < this.category.length; ++i) {
            g2.setColor(this.categoryColors.get(this.category[i]));
            this.drawPoint(g2, this.shapes[this.category[i]], this.xVals.get(i), this.yVals.get(i), width, height, this.pointSize, this.fillPoints);
            if (pp == null) continue;
            pp.getjProgressBar().setValue(i + 1);
        }
    }

    public void setPointShape(int i, Graph2D.PointShape shape) {
        this.shapes[i] = shape;
    }

    public Color getCategoryColor(int category) {
        return this.categoryColors.get(category);
    }

    public void setPointSize(double pointSize) {
        this.pointSize = pointSize;
    }

    public double getPointSize() {
        return this.pointSize;
    }

    public void setFillPoints(boolean fillPoints) {
        this.fillPoints = fillPoints;
    }

    public boolean isFillPoints() {
        return this.fillPoints;
    }
}

