/*
 * Decompiled with CFR 0.152.
 */
package jsat.driftdetectors;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

public abstract class BaseDriftDetector<V>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5857845807016446270L;
    protected int time = 0;
    protected int maxHistory = Integer.MAX_VALUE;
    protected boolean warning = false;
    protected boolean drifting = false;
    protected int driftStart = -1;
    protected Deque<V> history;

    protected BaseDriftDetector() {
    }

    protected BaseDriftDetector(BaseDriftDetector<V> toCopy) {
        this.time = toCopy.time;
        this.maxHistory = toCopy.maxHistory;
        this.warning = toCopy.warning;
        this.driftStart = toCopy.driftStart;
        if (toCopy.history != null) {
            this.history = new ArrayDeque<V>(toCopy.history.size());
            for (V v : toCopy.history) {
                this.history.add(v);
            }
        }
    }

    public boolean isWarning() {
        return this.warning;
    }

    public boolean isDrifting() {
        return this.drifting;
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    public void setMaxHistory(int maxHistory) {
        this.maxHistory = maxHistory;
        if (this.history != null) {
            if (this.maxHistory == 0) {
                this.history.clear();
            } else {
                while (this.history.size() > maxHistory) {
                    this.history.removeFirst();
                }
            }
        }
    }

    protected void addToHistory(V obj) {
        if (this.maxHistory < 1) {
            return;
        }
        if (this.history == null) {
            if (this.maxHistory != Integer.MAX_VALUE) {
                try {
                    this.history = new ArrayDeque<V>(this.maxHistory);
                }
                catch (Exception ex) {
                    this.history = new ArrayDeque<V>();
                }
            } else {
                this.history = new ArrayDeque<V>();
            }
        }
        if (this.history.size() == this.maxHistory) {
            this.history.removeFirst();
        }
        this.history.add(obj);
    }

    public void clearHistory() {
        if (this.history != null) {
            this.history.clear();
        }
    }

    public int getDriftAge() {
        if (this.driftStart == -1) {
            return -1;
        }
        return this.time - this.driftStart;
    }

    public List<V> getDriftedHistory() {
        int historyToGram;
        ArrayList<V> histList = new ArrayList<V>(historyToGram);
        Iterator<V> histIter = this.history.descendingIterator();
        for (historyToGram = Math.min(this.time - this.driftStart, this.history.size()); histIter.hasNext() && historyToGram > 0; --historyToGram) {
            histList.add(histIter.next());
        }
        return histList;
    }

    public abstract boolean addSample(double var1, V var3);

    public void driftHandled() {
        this.drifting = false;
        this.warning = false;
        this.driftStart = -1;
    }

    public abstract Object clone();
}

