/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.kernels;

import java.util.List;
import jsat.DataSet;
import jsat.distributions.Distribution;
import jsat.distributions.LogUniform;
import jsat.distributions.Uniform;
import jsat.distributions.kernels.BaseKernelTrick;
import jsat.linear.Vec;
import jsat.parameters.Parameter;

public class SigmoidKernel
extends BaseKernelTrick {
    private static final long serialVersionUID = 8066799016611439349L;
    private double alpha;
    private double c;

    public SigmoidKernel(double alpha, double C) {
        this.alpha = alpha;
        this.c = C;
    }

    public SigmoidKernel(double alpha) {
        this(alpha, 1.0);
    }

    public void setAlpha(double alpha) {
        if (Double.isInfinite(alpha) || Double.isNaN(alpha) || alpha == 0.0) {
            throw new IllegalArgumentException("alpha must be a real non zero value, not " + alpha);
        }
        this.alpha = alpha;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setC(double c) {
        if (c < 0.0 || Double.isNaN(c) || Double.isInfinite(c)) {
            throw new IllegalArgumentException("C must be non negative, not " + c);
        }
        this.c = c;
    }

    public double getC() {
        return this.c;
    }

    @Override
    public double eval(Vec a, Vec b) {
        return Math.tanh(this.alpha * a.dot(b) + this.c);
    }

    public static Distribution guessAlpha(DataSet d) {
        return new LogUniform(1.0E-12, 1000.0);
    }

    public static Distribution guessC(DataSet d) {
        return new Uniform(-2.4, 2.4);
    }

    @Override
    public List<Parameter> getParameters() {
        return Parameter.getParamsFromMethods(this);
    }

    @Override
    public Parameter getParameter(String paramName) {
        return Parameter.toParameterMap(this.getParameters()).get(paramName);
    }

    @Override
    public SigmoidKernel clone() {
        return new SigmoidKernel(this.alpha, this.c);
    }
}

