/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.kernels;

import java.util.List;
import jsat.DataSet;
import jsat.distributions.Distribution;
import jsat.distributions.kernels.BaseL2Kernel;
import jsat.distributions.kernels.RBFKernel;
import jsat.linear.Vec;

public class RationalQuadraticKernel
extends BaseL2Kernel {
    private static final long serialVersionUID = 6773399185851115840L;
    private double c;

    public RationalQuadraticKernel(double c) {
        this.c = c;
    }

    public void setC(double c) {
        if (c <= 0.0 || Double.isNaN(c) || Double.isInfinite(c)) {
            throw new IllegalArgumentException("coefficient must be in (0, Inf), not " + c);
        }
        this.c = c;
    }

    public double getC() {
        return this.c;
    }

    @Override
    public double eval(Vec a, Vec b) {
        double dist = Math.pow(a.pNormDist(2.0, b), 2.0);
        return 1.0 - dist / (dist + this.c);
    }

    @Override
    public double eval(int a, int b, List<? extends Vec> trainingSet, List<Double> cache) {
        double dist = this.getSqrdNorm(a, b, trainingSet, cache);
        return 1.0 - dist / (dist + this.c);
    }

    @Override
    public double eval(int a, Vec b, List<Double> qi, List<? extends Vec> vecs, List<Double> cache) {
        double dist = this.getSqrdNorm(a, b, qi, vecs, cache);
        return 1.0 - dist / (dist + this.c);
    }

    @Override
    public RationalQuadraticKernel clone() {
        return new RationalQuadraticKernel(this.c);
    }

    public static Distribution guessC(DataSet d) {
        return RBFKernel.guessSigma(d);
    }
}

