/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.discrete;

import jsat.distributions.discrete.DiscreteDistribution;
import jsat.math.SpecialMath;

public class Poisson
extends DiscreteDistribution {
    private double lambda;

    public Poisson() {
        this(1.0);
    }

    public Poisson(double lambda) {
        this.setLambda(lambda);
    }

    public void setLambda(double lambda) {
        if (Double.isNaN(lambda) || lambda <= 0.0 || Double.isInfinite(lambda)) {
            throw new IllegalArgumentException("lambda must be positive, not " + lambda);
        }
        this.lambda = lambda;
    }

    public double getLambda() {
        return this.lambda;
    }

    @Override
    public double logPmf(int x) {
        if (x < 0) {
            return -1.7976931348623157E308;
        }
        return -SpecialMath.lnGamma(x + 1) - this.lambda + (double)x * Math.log(this.lambda);
    }

    @Override
    public double pmf(int x) {
        if (x < 0) {
            return 0.0;
        }
        return Math.exp(this.logPmf(x));
    }

    @Override
    public double cdf(int x) {
        if (x < 0) {
            return 0.0;
        }
        return SpecialMath.gammaQ(x + 1, this.lambda);
    }

    @Override
    public double mean() {
        return this.lambda;
    }

    @Override
    public double mode() {
        if (this.lambda < 1.0) {
            return 0.0;
        }
        if (this.lambda > 1.0 && Math.rint(this.lambda) != this.lambda) {
            return Math.floor(this.lambda);
        }
        return this.lambda;
    }

    @Override
    public double variance() {
        return this.lambda;
    }

    @Override
    public double skewness() {
        return 1.0 / this.standardDeviation();
    }

    @Override
    public double min() {
        return 0.0;
    }

    @Override
    public double max() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Poisson clone() {
        return new Poisson(this.lambda);
    }
}

