/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.discrete;

import jsat.distributions.Distribution;
import jsat.linear.Vec;
import jsat.math.Function;
import jsat.math.FunctionBase;
import jsat.math.rootfinding.Zeroin;

public abstract class DiscreteDistribution
extends Distribution {
    public double logPmf(int x) {
        double pmf = this.pmf(x);
        if (pmf <= 0.0) {
            return -1.7976931348623157E308;
        }
        return Math.log(pmf);
    }

    public abstract double pmf(int var1);

    public abstract double cdf(int var1);

    @Override
    public double cdf(double x) {
        return this.cdf((int)Math.floor(x));
    }

    @Override
    public double invCdf(double p) {
        if (this.min() >= -2.147483648E9 && p <= this.cdf(this.min())) {
            return this.min();
        }
        if (this.max() < 2.147483647E9 && p > this.cdf(this.max() - 1.0)) {
            return this.max();
        }
        double toRet = this.invCdf(p, new FunctionBase(){

            @Override
            public double f(Vec x) {
                double query = x.get(0);
                if (Math.rint(query) == query) {
                    return DiscreteDistribution.this.cdf((int)query);
                }
                double larger = query + 1.0;
                double diff = larger - query;
                return DiscreteDistribution.this.cdf(query) * diff + DiscreteDistribution.this.cdf(larger) * (1.0 - diff);
            }
        });
        return Math.round(toRet);
    }

    @Override
    protected double invCdf(final double p, final Function cdf) {
        if (p < 0.0 || p > 1.0) {
            throw new ArithmeticException("Value of p must be in the range [0,1], not " + p);
        }
        double a = Double.isInfinite(this.min()) ? -2.0401094656E9 : this.min();
        double b = Double.isInfinite(this.max()) ? 2.0401094646499999E9 : this.max();
        Function newCDF = new Function(){

            @Override
            public double f(double ... x) {
                return cdf.f(x) - p;
            }

            @Override
            public double f(Vec x) {
                return this.f(x.get(0));
            }
        };
        return Zeroin.root(1.0E-6, a, b, newCDF, p);
    }

    @Override
    public abstract DiscreteDistribution clone();
}

