/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.ContinuousDistribution;
import jsat.linear.Vec;
import jsat.math.SpecialMath;

public class MaxwellBoltzmann
extends ContinuousDistribution {
    private static final long serialVersionUID = -8273087046831433430L;
    double sigma;

    public MaxwellBoltzmann() {
        this(1.0);
    }

    public MaxwellBoltzmann(double sigma) {
        this.setShape(sigma);
    }

    public final void setShape(double sigma) {
        if (sigma <= 0.0 || Double.isInfinite(sigma) || Double.isNaN(sigma)) {
            throw new ArithmeticException("shape parameter must be > 0, not " + sigma);
        }
        this.sigma = sigma;
    }

    @Override
    public double logPdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return 2.0 * Math.log(x) + -x * x / (2.0 * this.sigma * this.sigma) - 3.0 * Math.log(this.sigma) + 0.5 * (Math.log(2.0) - Math.log(Math.PI));
    }

    @Override
    public double pdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double x2 = x * x;
        return Math.sqrt(0.6366197723675814) * x2 * Math.exp(-x2 / (2.0 * this.sigma * this.sigma)) / (this.sigma * this.sigma * this.sigma);
    }

    @Override
    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return SpecialMath.erf(x / (Math.sqrt(2.0) * this.sigma)) - Math.sqrt(0.6366197723675814) * x * Math.exp(-(x * x) / (2.0 * this.sigma * this.sigma)) / this.sigma;
    }

    @Override
    public double invCdf(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new ArithmeticException("probability must be in the range [0,1], not " + p);
        }
        return Math.sqrt(2.0) * this.sigma * Math.sqrt(SpecialMath.invGammaP(p, 1.5));
    }

    @Override
    public double median() {
        return this.sigma * Math.sqrt(2.0 * SpecialMath.invGammaP(0.5, 1.5));
    }

    @Override
    public double min() {
        return 0.0;
    }

    @Override
    public double max() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public String getDistributionName() {
        return "Maxwell\u2013Boltzmann";
    }

    @Override
    public String[] getVariables() {
        return new String[]{"\u03c3"};
    }

    @Override
    public double[] getCurrentVariableValues() {
        return new double[]{this.sigma};
    }

    @Override
    public void setVariable(String var, double value) {
        if (var.equals("\u03c3")) {
            this.setShape(value);
        }
    }

    @Override
    public ContinuousDistribution clone() {
        return new MaxwellBoltzmann(this.sigma);
    }

    @Override
    public void setUsingData(Vec data) {
        this.setShape(data.mean() / Math.sqrt(2.0));
    }

    @Override
    public double mean() {
        return 2.0 * Math.sqrt(0.6366197723675814) * this.sigma;
    }

    @Override
    public double mode() {
        return Math.sqrt(2.0) * this.sigma;
    }

    @Override
    public double variance() {
        return this.sigma * this.sigma * 1.4247779607693793 / Math.PI;
    }

    @Override
    public double skewness() {
        return 2.0 * Math.sqrt(2.0) * 0.2920367320510344 / Math.pow(1.4247779607693793, 1.5);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.sigma);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MaxwellBoltzmann other = (MaxwellBoltzmann)obj;
        return Double.doubleToLongBits(this.sigma) == Double.doubleToLongBits(other.sigma);
    }
}

