/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.ContinuousDistribution;
import jsat.linear.Vec;

public class LogUniform
extends ContinuousDistribution {
    private double min;
    private double max;
    private double logMin;
    private double logMax;
    private double logDiff;
    private double diff;

    public LogUniform() {
        this(0.01, 1.0);
    }

    public LogUniform(double min, double max) {
        this.setMinMax(min, max);
    }

    public void setMinMax(double min, double max) {
        if (min <= 0.0 || Double.isNaN(min) || Double.isInfinite(min)) {
            throw new IllegalArgumentException("min value must be positive, not " + min);
        }
        if (min >= max || Double.isNaN(max) || Double.isInfinite(max)) {
            throw new IllegalArgumentException("max (" + max + ") must be larger than min (" + min + ")");
        }
        this.max = max;
        this.min = min;
        this.logMax = Math.log(max);
        this.logMin = Math.log(min);
        this.logDiff = this.logMax - this.logMin;
        this.diff = max - min;
    }

    @Override
    public double pdf(double x) {
        if (x < this.min) {
            return 0.0;
        }
        if (x > this.max) {
            return 0.0;
        }
        return 1.0 / (x * (this.logMax - this.logMin));
    }

    @Override
    public String getDistributionName() {
        return "LogUniform";
    }

    @Override
    public String[] getVariables() {
        return new String[]{"min", "max"};
    }

    @Override
    public double[] getCurrentVariableValues() {
        return new double[]{this.min, this.max};
    }

    @Override
    public void setVariable(String var, double value) {
        if (var.equals("min")) {
            this.setMinMax(value, this.max);
        } else if (var.equals("max")) {
            this.setMinMax(this.min, value);
        }
    }

    @Override
    public LogUniform clone() {
        return new LogUniform(this.min, this.max);
    }

    @Override
    public void setUsingData(Vec data) {
        double guessMin = data.min();
        double guessMax = data.max();
        this.setMinMax(Math.max(guessMin, 1.0E-10), guessMax);
    }

    @Override
    public double cdf(double x) {
        if (x < this.min) {
            return 0.0;
        }
        if (x > this.max) {
            return 1.0;
        }
        return (Math.log(x) - this.logMin) / this.logDiff;
    }

    @Override
    public double invCdf(double p) {
        if (p < 0.0 || p > 1.0 || Double.isNaN(p)) {
            throw new IllegalArgumentException("p must be in [0,1], not " + p);
        }
        return Math.exp(p * this.logMax - p * this.logMin) * this.min;
    }

    @Override
    public double mean() {
        return this.diff / this.logDiff;
    }

    @Override
    public double median() {
        return Math.sqrt(this.min) * Math.sqrt(this.max);
    }

    @Override
    public double mode() {
        return this.min();
    }

    @Override
    public double variance() {
        return (this.max * this.max - this.min * this.min) / (2.0 * this.logDiff) - this.diff * this.diff / (this.logDiff * this.logDiff);
    }

    @Override
    public double skewness() {
        return Double.NaN;
    }

    @Override
    public double min() {
        return this.min;
    }

    @Override
    public double max() {
        return this.max;
    }
}

