/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.ContinuousDistribution;
import jsat.distributions.Exponential;
import jsat.distributions.FisherSendor;
import jsat.distributions.Gamma;
import jsat.distributions.LogNormal;
import jsat.distributions.Logistic;
import jsat.distributions.MaxwellBoltzmann;
import jsat.distributions.Normal;
import jsat.distributions.Pareto;
import jsat.distributions.Rayleigh;
import jsat.distributions.Uniform;
import jsat.distributions.Weibull;
import jsat.distributions.empirical.KernelDensityEstimator;
import jsat.linear.Vec;
import jsat.testing.goodnessoffit.KSTest;

public class DistributionSearch {
    private static ContinuousDistribution[] possibleDistributions = new ContinuousDistribution[]{new Normal(), new LogNormal(), new Exponential(), new Gamma(2.0, 1.0), new FisherSendor(10.0, 10.0), new Weibull(2.0, 1.0), new Uniform(0.0, 1.0), new Logistic(3.0, 2.0), new MaxwellBoltzmann(), new Pareto(), new Rayleigh(2.0)};

    public static ContinuousDistribution getBestDistribution(Vec v) {
        return DistributionSearch.getBestDistribution(v, possibleDistributions);
    }

    public static ContinuousDistribution getBestDistribution(Vec v, double KDECutOff) {
        return DistributionSearch.getBestDistribution(v, KDECutOff, possibleDistributions);
    }

    public static ContinuousDistribution getBestDistribution(Vec v, ContinuousDistribution ... possibleDistributions) {
        return DistributionSearch.getBestDistribution(v, 0.0, possibleDistributions);
    }

    public static ContinuousDistribution getBestDistribution(Vec v, double KDECutOff, ContinuousDistribution ... possibleDistributions) {
        if (v.length() == 0) {
            throw new ArithmeticException("Can not fit a distribution to an empty set");
        }
        ContinuousDistribution[] possDistCopy = new ContinuousDistribution[possibleDistributions.length];
        for (int i = 0; i < possibleDistributions.length; ++i) {
            possDistCopy[i] = possibleDistributions[i].clone();
        }
        KSTest ksTest = new KSTest(v);
        ContinuousDistribution bestDist = null;
        double bestProb = 0.0;
        for (ContinuousDistribution cd : possDistCopy) {
            try {
                cd.setUsingData(v);
                double prob = ksTest.testDist(cd);
                if (!(prob > bestProb)) continue;
                bestDist = cd;
                bestProb = prob;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            if (bestProb >= KDECutOff) {
                return bestDist == null ? new Normal(v.mean(), v.standardDeviation()) : bestDist.clone();
            }
            return new KernelDensityEstimator(v);
        }
        catch (RuntimeException ex) {
            if (v.standardDeviation() == 0.0) {
                return null;
            }
            throw new ArithmeticException("Catistrophic faulure getting a distribution");
        }
    }
}

