/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.Distribution;
import jsat.linear.DenseVector;
import jsat.linear.Vec;
import jsat.math.Function;

public abstract class ContinuousDistribution
extends Distribution {
    private static final long serialVersionUID = -5079392926462355615L;

    public double logPdf(double x) {
        double pdf = this.pdf(x);
        if (pdf <= 0.0) {
            return -1.7976931348623157E308;
        }
        return Math.log(pdf);
    }

    public abstract double pdf(double var1);

    public String getDescriptiveName() {
        StringBuilder sb = new StringBuilder(this.getDistributionName());
        sb.append("(");
        String[] vars = this.getVariables();
        double[] vals = this.getCurrentVariableValues();
        sb.append(vars[0]).append(" = ").append(vals[0]);
        for (int i = 1; i < vars.length; ++i) {
            sb.append(", ").append(vars[i]).append(" = ").append(vals[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    public abstract String getDistributionName();

    public abstract String[] getVariables();

    public abstract double[] getCurrentVariableValues();

    public abstract void setVariable(String var1, double var2);

    @Override
    public abstract ContinuousDistribution clone();

    public abstract void setUsingData(Vec var1);

    public String toString() {
        return this.getDistributionName();
    }

    public static Function getFunctionPDF(final ContinuousDistribution dist) {
        return new Function(){
            private static final long serialVersionUID = -897452735980141746L;

            @Override
            public double f(double ... x) {
                return this.f(DenseVector.toDenseVec(x));
            }

            @Override
            public double f(Vec x) {
                return dist.pdf(x.get(0));
            }
        };
    }
}

