/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform.kernel;

import java.util.Random;
import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.datatransform.DataTransform;
import jsat.datatransform.DataTransformFactory;
import jsat.datatransform.DataTransformFactoryParm;
import jsat.distributions.Distribution;
import jsat.distributions.kernels.RBFKernel;
import jsat.linear.DenseVector;
import jsat.linear.Matrix;
import jsat.linear.RandomMatrix;
import jsat.linear.RandomVector;
import jsat.linear.Vec;

public class RFF_RBF
implements DataTransform {
    private static final long serialVersionUID = -3478916020648280477L;
    private Matrix transform;
    private Vec offsets;

    public RFF_RBF(int featurSize, double sigma, int dim, Random rand, boolean inMemory) {
        if (featurSize <= 0) {
            throw new IllegalArgumentException("The number of numeric features must be positive, not " + featurSize);
        }
        if (sigma <= 0.0 || Double.isInfinite(sigma) || Double.isNaN(sigma)) {
            throw new IllegalArgumentException("The sigma parameter must be positive, not " + sigma);
        }
        if (dim <= 1) {
            throw new IllegalArgumentException("The target dimension must be positive, not " + dim);
        }
        this.transform = new RandomMatrixRFF_RBF(Math.sqrt(0.5 / (sigma * sigma)), featurSize, dim, rand.nextLong());
        this.offsets = new RandomVectorRFF_RBF(dim, rand.nextLong());
        if (inMemory) {
            this.transform = this.transform.add(0.0);
            this.offsets = new DenseVector(this.offsets);
        }
    }

    protected RFF_RBF(RFF_RBF toCopy) {
        this.transform = toCopy.transform.clone();
        this.offsets = toCopy.offsets.clone();
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        Vec oldX = dp.getNumericalValues();
        Vec newX = oldX.multiply(this.transform);
        double coef = Math.sqrt(2.0 / (double)this.transform.cols());
        for (int i = 0; i < newX.length(); ++i) {
            newX.set(i, Math.cos(newX.get(i) + this.offsets.get(i)) * coef);
        }
        return new DataPoint(newX, dp.getCategoricalValues(), dp.getCategoricalData(), dp.getWeight());
    }

    @Override
    public RFF_RBF clone() {
        return new RFF_RBF(this);
    }

    public static class RFF_RBFTransformFactory
    extends DataTransformFactoryParm {
        private double sigma;
        private int dimensions;
        private boolean inMemory;

        public RFF_RBFTransformFactory(double sigma, int dimensions, boolean inMemory) {
            this.setSigma(sigma);
            this.setDimensions(dimensions);
            this.inMemory = inMemory;
        }

        public RFF_RBFTransformFactory(RFF_RBFTransformFactory toCopy) {
            this(toCopy.sigma, toCopy.dimensions, toCopy.inMemory);
        }

        @Override
        public DataTransformFactory clone() {
            return new RFF_RBFTransformFactory(this);
        }

        @Override
        public DataTransform getTransform(DataSet dataset) {
            return new RFF_RBF(dataset.getNumNumericalVars(), this.sigma, this.dimensions, new Random(), this.inMemory);
        }

        public void setDimensions(int dimensions) {
            if (dimensions < 1) {
                throw new ArithmeticException("Number of dimensions must be a positive value, not " + dimensions);
            }
            this.dimensions = dimensions;
        }

        public int getDimensions() {
            return this.dimensions;
        }

        public void setSigma(double sigma) {
            if (sigma <= 0.0 || Double.isInfinite(sigma) || Double.isNaN(sigma)) {
                throw new IllegalArgumentException("Sigma must be a positive value, not " + sigma);
            }
            this.sigma = sigma;
        }

        public double getSigma() {
            return this.sigma;
        }

        public Distribution guessSigma(DataSet d) {
            return RBFKernel.guessSigma(d);
        }
    }

    private static class RandomVectorRFF_RBF
    extends RandomVector {
        private static final long serialVersionUID = -6132378281909907937L;

        public RandomVectorRFF_RBF(int length, long seedMult) {
            super(length, seedMult);
        }

        @Override
        protected double getVal(Random rand) {
            return rand.nextDouble() * 2.0 * Math.PI;
        }

        @Override
        public Vec clone() {
            return this;
        }
    }

    private static class RandomMatrixRFF_RBF
    extends RandomMatrix {
        private static final long serialVersionUID = 4702514384718636893L;
        private double coef;

        public RandomMatrixRFF_RBF(double coef, int rows, int cols, long seedMult) {
            super(rows, cols, seedMult);
            this.coef = coef;
        }

        @Override
        protected double getVal(Random rand) {
            return this.coef * rand.nextGaussian();
        }
    }
}

