/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform.kernel;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.datatransform.DataTransform;
import jsat.datatransform.DataTransformFactoryParm;
import jsat.datatransform.kernel.Nystrom;
import jsat.distributions.kernels.KernelTrick;
import jsat.linear.DenseMatrix;
import jsat.linear.DenseVector;
import jsat.linear.EigenValueDecomposition;
import jsat.linear.Matrix;
import jsat.linear.RowColumnOps;
import jsat.linear.Vec;
import jsat.parameters.Parameter;
import jsat.utils.random.XOR96;

public class KernelPCA
implements DataTransform {
    private static final long serialVersionUID = 5676602024560381043L;
    private int dimensions;
    private KernelTrick k;
    private double[] eigenVals;
    private Matrix eigenVecs;
    private Vec[] vecs;
    private double[] rowAvg;
    private double allAvg;

    public KernelPCA(KernelTrick k, DataSet ds, int dimensions, int basisSize, Nystrom.SamplingMethod samplingMethod) {
        int i;
        int i2;
        this.dimensions = dimensions;
        this.k = k;
        if (ds.getSampleSize() <= basisSize) {
            this.vecs = new Vec[ds.getSampleSize()];
            for (i2 = 0; i2 < this.vecs.length; ++i2) {
                this.vecs[i2] = ds.getDataPoint(i2).getNumericalValues();
            }
        } else {
            i2 = 0;
            List<Vec> sample = Nystrom.sampleBasisVectors(k, ds, ds.getDataVectors(), samplingMethod, basisSize, false, new XOR96());
            this.vecs = new Vec[sample.size()];
            for (Vec v : sample) {
                this.vecs[i2++] = v;
            }
        }
        DenseMatrix K = new DenseMatrix(this.vecs.length, this.vecs.length);
        this.rowAvg = new double[((Matrix)K).rows()];
        this.allAvg = 0.0;
        for (i = 0; i < ((Matrix)K).rows(); ++i) {
            Vec x_i = this.vecs[i];
            for (int j = i; j < ((Matrix)K).cols(); ++j) {
                double K_ij = k.eval(x_i, this.vecs[j]);
                ((Matrix)K).set(i, j, K_ij);
                ((Matrix)K).set(j, i, K_ij);
            }
        }
        for (i = 0; i < ((Matrix)K).rows(); ++i) {
            for (int j = 0; j < ((Matrix)K).cols(); ++j) {
                int n = i;
                this.rowAvg[n] = this.rowAvg[n] + ((Matrix)K).get(i, j);
            }
        }
        i = 0;
        while (i < ((Matrix)K).rows()) {
            this.allAvg += this.rowAvg[i];
            int n = i++;
            this.rowAvg[n] = this.rowAvg[n] / (double)((Matrix)K).rows();
        }
        this.allAvg /= (double)(((Matrix)K).rows() * ((Matrix)K).cols());
        for (i = 0; i < ((Matrix)K).rows(); ++i) {
            for (int j = 0; j < ((Matrix)K).cols(); ++j) {
                ((Matrix)K).set(i, j, ((Matrix)K).get(i, j) - this.rowAvg[i] - this.rowAvg[j] + this.allAvg);
            }
        }
        EigenValueDecomposition evd = new EigenValueDecomposition(K);
        evd.sortByEigenValue(new Comparator<Double>(){

            @Override
            public int compare(Double o1, Double o2) {
                return -Double.compare(o1, o2);
            }
        });
        this.eigenVals = evd.getRealEigenvalues();
        this.eigenVecs = evd.getV();
        for (int j = 0; j < this.eigenVals.length; ++j) {
            RowColumnOps.divCol(this.eigenVecs, j, Math.sqrt(this.eigenVals[j]));
        }
    }

    protected KernelPCA(KernelPCA toCopy) {
        this.dimensions = toCopy.dimensions;
        this.k = toCopy.k.clone();
        this.eigenVals = Arrays.copyOf(toCopy.eigenVals, toCopy.eigenVals.length);
        this.eigenVecs = toCopy.eigenVecs.clone();
        this.vecs = new Vec[toCopy.vecs.length];
        for (int i = 0; i < this.vecs.length; ++i) {
            this.vecs[i] = toCopy.vecs[i].clone();
        }
        this.rowAvg = Arrays.copyOf(toCopy.rowAvg, toCopy.rowAvg.length);
        this.allAvg = toCopy.allAvg;
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        Vec oldVec = dp.getNumericalValues();
        DenseVector newVec = new DenseVector(this.dimensions);
        double[] kEvals = new double[this.vecs.length];
        double tAvg = 0.0;
        for (int j = 0; j < this.vecs.length; ++j) {
            kEvals[j] = this.k.eval(this.vecs[j], oldVec);
            tAvg += kEvals[j];
        }
        tAvg /= (double)this.vecs.length;
        for (int i = 0; i < this.dimensions; ++i) {
            double val = 0.0;
            for (int j = 0; j < this.vecs.length; ++j) {
                val += this.eigenVecs.get(j, i) * (kEvals[j] - tAvg - this.rowAvg[i] + this.allAvg);
            }
            ((Vec)newVec).set(i, val);
        }
        return new DataPoint(newVec, dp.getCategoricalValues(), dp.getCategoricalData(), dp.getWeight());
    }

    @Override
    public KernelPCA clone() {
        return new KernelPCA(this);
    }

    public static class KernelPCATransformFactory
    extends DataTransformFactoryParm {
        @Parameter.ParameterHolder
        private KernelTrick k;
        private int dimension;
        private int basisSize;
        private Nystrom.SamplingMethod method;

        public KernelPCATransformFactory(KernelTrick k, int dimension, int basisSize, Nystrom.SamplingMethod samplingMethod) {
            this.k = k;
            this.setDimension(dimension);
            this.setBasisSize(basisSize);
            this.setBasisSamplingMethod(samplingMethod);
        }

        public KernelPCATransformFactory(KernelPCATransformFactory toCopy) {
            this(toCopy.k.clone(), toCopy.dimension, toCopy.basisSize, toCopy.method);
        }

        public void setBasisSize(int basisSize) {
            if (basisSize < 1) {
                throw new IllegalArgumentException("The basis size must be positive, not " + basisSize);
            }
            this.basisSize = basisSize;
        }

        public int getBasisSize() {
            return this.basisSize;
        }

        public void setDimension(int dimension) {
            if (dimension < 1) {
                throw new IllegalArgumentException("The number of dimensions must be positive, not " + dimension);
            }
            this.dimension = dimension;
        }

        public int getDimension() {
            return this.dimension;
        }

        public void setBasisSamplingMethod(Nystrom.SamplingMethod method) {
            this.method = method;
        }

        public Nystrom.SamplingMethod getBasisSamplingMethod() {
            return this.method;
        }

        @Override
        public DataTransform getTransform(DataSet dataset) {
            return new KernelPCA(this.k, dataset, this.dimension, this.basisSize, this.method);
        }

        @Override
        public KernelPCATransformFactory clone() {
            return new KernelPCATransformFactory(this);
        }
    }
}

