/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.datatransform.DataTransform;
import jsat.datatransform.DataTransformFactory;
import jsat.datatransform.InPlaceInvertibleTransform;
import jsat.linear.DenseVector;
import jsat.linear.Vec;

public class ZeroMeanTransform
implements InPlaceInvertibleTransform {
    private static final long serialVersionUID = -7411115746918116163L;
    private Vec shiftVector;

    public ZeroMeanTransform(DataSet dataset) {
        this.shiftVector = new DenseVector(dataset.getNumNumericalVars());
        this.shiftVector = dataset.getColumnMeanVariance()[0];
    }

    private ZeroMeanTransform(ZeroMeanTransform other) {
        this.shiftVector = other.shiftVector.clone();
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        DataPoint newDP = dp.clone();
        this.mutableTransform(newDP);
        return newDP;
    }

    @Override
    public void mutableInverse(DataPoint dp) {
        dp.getNumericalValues().mutableAdd(this.shiftVector);
    }

    @Override
    public DataPoint inverse(DataPoint dp) {
        DataPoint newDP = dp.clone();
        this.mutableInverse(dp);
        return newDP;
    }

    @Override
    public void mutableTransform(DataPoint dp) {
        dp.getNumericalValues().mutableSubtract(this.shiftVector);
    }

    @Override
    public boolean mutatesNominal() {
        return false;
    }

    @Override
    public ZeroMeanTransform clone() {
        return new ZeroMeanTransform(this);
    }

    public static class ZeroMeanTransformFactory
    implements DataTransformFactory {
        @Override
        public DataTransform getTransform(DataSet dataset) {
            return new ZeroMeanTransform(dataset);
        }

        @Override
        public ZeroMeanTransformFactory clone() {
            return new ZeroMeanTransformFactory();
        }
    }
}

