/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.datatransform.DataTransform;
import jsat.datatransform.DataTransformFactoryParm;
import jsat.datatransform.InPlaceTransform;
import jsat.datatransform.WhitenedPCA;
import jsat.linear.DenseVector;
import jsat.linear.Matrix;
import jsat.linear.SingularValueDecomposition;
import jsat.linear.Vec;

public class WhitenedZCA
extends WhitenedPCA
implements InPlaceTransform {
    private static final long serialVersionUID = 7546033727733619587L;
    private final ThreadLocal<Vec> tempVecs;

    public WhitenedZCA(DataSet dataSet, double regularization) {
        super(dataSet, regularization);
        this.tempVecs = this.getThreadLocal(dataSet.getNumNumericalVars());
    }

    public WhitenedZCA(DataSet dataSet) {
        super(dataSet);
        this.tempVecs = this.getThreadLocal(dataSet.getNumNumericalVars());
    }

    @Override
    public void mutableTransform(DataPoint dp) {
        Vec target = this.tempVecs.get();
        target.zeroOut();
        this.transform.multiply(dp.getNumericalValues(), 1.0, target);
        target.copyTo(dp.getNumericalValues());
    }

    @Override
    public boolean mutatesNominal() {
        return false;
    }

    @Override
    protected void setUpTransform(SingularValueDecomposition svd) {
        double[] s = svd.getSingularValues();
        DenseVector diag = new DenseVector(s.length);
        for (int i = 0; i < s.length; ++i) {
            ((Vec)diag).set(i, 1.0 / Math.sqrt(s[i] + this.regularization));
        }
        Matrix U = svd.getU();
        this.transform = U.multiply(Matrix.diag(diag)).multiply(U.transpose());
    }

    private ThreadLocal<Vec> getThreadLocal(final int dim) {
        return new ThreadLocal<Vec>(){

            @Override
            protected Vec initialValue() {
                return new DenseVector(dim);
            }
        };
    }

    public static class WhitenedZCATransformFactory
    extends DataTransformFactoryParm {
        private double reg;
        private boolean autoReg;

        public WhitenedZCATransformFactory(double reg) {
            this.setRegularization(reg);
            this.autoReg = true;
        }

        public WhitenedZCATransformFactory() {
            this(1.0);
            this.autoReg = false;
        }

        public WhitenedZCATransformFactory(WhitenedZCATransformFactory toCopy) {
            this.reg = toCopy.reg;
            this.autoReg = toCopy.autoReg;
        }

        public void setAutoReg(boolean autoReg) {
            this.autoReg = autoReg;
        }

        public boolean isAutoReg() {
            return this.autoReg;
        }

        public void setRegularization(double reg) {
            if (reg <= 0.0 || Double.isNaN(reg) || Double.isInfinite(reg)) {
                throw new IllegalArgumentException("Regularization must be a positive value, not " + reg);
            }
            this.reg = reg;
        }

        public double getRegularization() {
            return this.reg;
        }

        @Override
        public DataTransform getTransform(DataSet dataset) {
            if (this.autoReg) {
                return new WhitenedZCA(dataset);
            }
            return new WhitenedZCA(dataset, this.reg);
        }

        @Override
        public WhitenedZCATransformFactory clone() {
            return new WhitenedZCATransformFactory(this);
        }
    }
}

