/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.datatransform.DataTransform;
import jsat.datatransform.DataTransformFactory;
import jsat.datatransform.InPlaceTransform;
import jsat.linear.Vec;

public class StandardizeTransform
implements InPlaceTransform {
    private static final long serialVersionUID = -2349721113741805955L;
    private Vec means;
    private Vec stdDevs;

    public StandardizeTransform(DataSet dataset) {
        Vec[] vecs = dataset.getColumnMeanVariance();
        this.means = vecs[0];
        this.stdDevs = vecs[1];
    }

    public StandardizeTransform(StandardizeTransform toCopy) {
        this.means = toCopy.means.clone();
        this.stdDevs = toCopy.stdDevs.clone();
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        DataPoint newDP = dp.clone();
        this.mutableTransform(newDP);
        return newDP;
    }

    @Override
    public void mutableTransform(DataPoint dp) {
        Vec toAlter = dp.getNumericalValues();
        toAlter.mutableSubtract(this.means);
        toAlter.mutablePairwiseDivide(this.stdDevs);
    }

    @Override
    public boolean mutatesNominal() {
        return false;
    }

    @Override
    public StandardizeTransform clone() {
        return new StandardizeTransform(this);
    }

    public static class StandardizeTransformFactory
    implements DataTransformFactory {
        @Override
        public DataTransform getTransform(DataSet dataset) {
            return new StandardizeTransform(dataset);
        }

        @Override
        public DataTransformFactory clone() {
            return new StandardizeTransformFactory();
        }
    }
}

