/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import java.util.Arrays;
import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.datatransform.DataTransform;
import jsat.datatransform.DataTransformFactoryParm;
import jsat.linear.DenseVector;
import jsat.linear.Vec;

public class PolynomialTransform
implements DataTransform {
    private static final long serialVersionUID = -5332216444253168283L;
    private int degree;

    public PolynomialTransform(int degree) {
        if (degree < 2) {
            throw new ArithmeticException("The degree of the polynomial was a nonsense value: " + degree);
        }
        this.degree = degree;
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        Vec x = dp.getNumericalValues();
        int[] setTo = new int[x.length()];
        int finalSize = 0;
        int curCount = this.increment(setTo, this.degree, 0);
        do {
            ++finalSize;
            curCount = this.increment(setTo, this.degree, curCount);
        } while (setTo[x.length() - 1] <= this.degree);
        double[] newVec = new double[finalSize];
        Arrays.fill(newVec, 1.0);
        int index = 0;
        Arrays.fill(setTo, 0);
        curCount = this.increment(setTo, this.degree, 0);
        do {
            for (int i = 0; i < setTo.length; ++i) {
                if (setTo[i] <= 0) continue;
                int n = index;
                newVec[n] = newVec[n] * Math.pow(x.get(i), setTo[i]);
            }
            ++index;
            curCount = this.increment(setTo, this.degree, curCount);
        } while (setTo[x.length() - 1] <= this.degree);
        return new DataPoint(new DenseVector(newVec), dp.getCategoricalValues(), dp.getCategoricalData(), dp.getWeight());
    }

    private int increment(int[] setTo, int max, int curCount) {
        setTo[0] = setTo[0] + 1;
        if (++curCount <= max) {
            return curCount;
        }
        int carryPos = 0;
        while (carryPos < setTo.length - 1 && curCount > max) {
            curCount -= setTo[carryPos];
            setTo[carryPos] = 0;
            int n = ++carryPos;
            setTo[n] = setTo[n] + 1;
            ++curCount;
        }
        return curCount;
    }

    @Override
    public DataTransform clone() {
        return new PolynomialTransform(this.degree);
    }

    public static class PolyTransformFactory
    extends DataTransformFactoryParm {
        private int degree;

        public PolyTransformFactory(int degree) {
            this.setDegree(degree);
        }

        public void setDegree(int degree) {
            if (degree < 1) {
                throw new IllegalArgumentException("Degree must be a positive value, not " + degree);
            }
            this.degree = degree;
        }

        public int getDegree() {
            return this.degree;
        }

        @Override
        public PolynomialTransform getTransform(DataSet dataset) {
            return new PolynomialTransform(this.degree);
        }

        @Override
        public PolyTransformFactory clone() {
            return new PolyTransformFactory(this.degree);
        }
    }
}

