/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.datatransform.DataTransform;
import jsat.datatransform.DataTransformFactoryParm;
import jsat.datatransform.InPlaceTransform;
import jsat.linear.Vec;

public class PNormNormalization
implements InPlaceTransform {
    private static final long serialVersionUID = 2934569881395909607L;
    private double p;

    public PNormNormalization(double p) {
        if (p <= 0.0 || Double.isNaN(p)) {
            throw new IllegalArgumentException("p must be greater than zero, not " + p);
        }
        this.p = p;
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        DataPoint dpNew = dp.clone();
        this.mutableTransform(dpNew);
        return dpNew;
    }

    @Override
    public void mutableTransform(DataPoint dp) {
        Vec vec = dp.getNumericalValues();
        double norm = vec.pNorm(this.p);
        if (norm != 0.0) {
            vec.mutableDivide(norm);
        }
    }

    @Override
    public boolean mutatesNominal() {
        return false;
    }

    @Override
    public PNormNormalization clone() {
        return new PNormNormalization(this.p);
    }

    public static class PNormNormalizationFactory
    extends DataTransformFactoryParm {
        private double p;

        public PNormNormalizationFactory(double p) {
            this.p = p;
        }

        public PNormNormalizationFactory(PNormNormalizationFactory toCopy) {
            this.p = toCopy.p;
        }

        public void setPNorm(double p) {
            if (p <= 0.0 || Double.isNaN(p)) {
                throw new IllegalArgumentException("p must be greater than zero, not " + p);
            }
            this.p = p;
        }

        public double getPNorm() {
            return this.p;
        }

        @Override
        public DataTransform getTransform(DataSet dataset) {
            return new PNormNormalization(this.p);
        }

        @Override
        public PNormNormalizationFactory clone() {
            return new PNormNormalizationFactory(this);
        }
    }
}

