/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import java.util.ArrayList;
import java.util.Arrays;
import jsat.DataSet;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.DataPoint;
import jsat.datatransform.DataTransform;
import jsat.datatransform.DataTransformFactoryParm;
import jsat.linear.DenseMatrix;
import jsat.linear.Matrix;
import jsat.linear.Vec;

public class PCA
implements DataTransform {
    private static final long serialVersionUID = 8736609877239941617L;
    private Matrix P;

    public PCA(DataSet dataSet) {
        this(dataSet, Integer.MAX_VALUE);
    }

    public PCA(DataSet dataSet, int maxPCs) {
        this(dataSet, maxPCs, 1.0E-4);
    }

    public PCA(DataSet dataSet, int maxPCs, double threshold) {
        int i;
        ArrayList<Vec> scores = new ArrayList<Vec>();
        ArrayList<Vec> loadings = new ArrayList<Vec>();
        Matrix E = dataSet.getDataMatrix();
        int PCs = Math.min(dataSet.getSampleSize(), dataSet.getNumNumericalVars());
        PCs = Math.min(maxPCs, PCs);
        Vec t = PCA.getColumn(E);
        double tauOld = t.dot(t);
        for (i = 1; i <= PCs; ++i) {
            Vec p = E.transposeMultiply(1.0, t);
            p.mutableDivide(tauOld);
            p.mutableMultiply(Math.pow(p.dot(p), -0.5));
            t = E.multiply(p);
            t.mutableDivide(p.dot(p));
            scores.add(t);
            loadings.add(p);
            double tauNew = t.dot(t);
            if (Math.abs(tauNew - tauOld) <= threshold * tauNew) {
                return;
            }
            tauOld = tauNew;
            Matrix.OuterProductUpdate(E, t, p, -1.0);
        }
        this.P = new DenseMatrix(loadings.size(), ((Vec)loadings.get(0)).length());
        for (i = 0; i < loadings.size(); ++i) {
            Vec pi = (Vec)loadings.get(i);
            for (int j = 0; j < pi.length(); ++j) {
                this.P.set(i, j, pi.get(j));
            }
        }
    }

    private PCA(PCA other) {
        if (other.P != null) {
            this.P = other.P.clone();
        }
    }

    private static Vec getColumn(Matrix x) {
        for (int i = 0; i < x.cols(); ++i) {
            Vec t = x.getColumn(i);
            if (!(t.dot(t) > 0.0)) continue;
            return t;
        }
        throw new ArithmeticException("Matrix is essentially zero");
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        DataPoint newDP = new DataPoint(this.P.multiply(dp.getNumericalValues()), Arrays.copyOf(dp.getCategoricalValues(), dp.numCategoricalValues()), CategoricalData.copyOf(dp.getCategoricalData()), dp.getWeight());
        return newDP;
    }

    @Override
    public DataTransform clone() {
        return new PCA(this);
    }

    public static class PCAFactory
    extends DataTransformFactoryParm {
        private int maxPCs;
        private double threshold;

        public PCAFactory() {
            this(Integer.MAX_VALUE);
        }

        public PCAFactory(int maxPCs) {
            this(maxPCs, 1.0E-4);
        }

        public PCAFactory(int maxPCs, double threshold) {
            this.setMaxPCs(maxPCs);
            this.setThreshold(threshold);
        }

        public PCAFactory(PCAFactory toCopy) {
            this(toCopy.maxPCs, toCopy.threshold);
        }

        public void setMaxPCs(int maxPCs) {
            if (maxPCs < 1) {
                throw new IllegalArgumentException("Number of PCs must be positive, not " + maxPCs);
            }
            this.maxPCs = maxPCs;
        }

        public int getMaxPCs() {
            return this.maxPCs;
        }

        public void setThreshold(double threshold) {
            this.threshold = threshold;
        }

        public double getThreshold() {
            return this.threshold;
        }

        @Override
        public DataTransform getTransform(DataSet dataset) {
            return new PCA(dataset, this.maxPCs, this.threshold);
        }

        @Override
        public PCAFactory clone() {
            return new PCAFactory(this);
        }
    }
}

