/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import java.util.Arrays;
import jsat.DataSet;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.DataPoint;
import jsat.datatransform.DataTransform;
import jsat.datatransform.DataTransformFactoryParm;
import jsat.linear.DenseVector;
import jsat.linear.Vec;

public class NumericalToHistogram
implements DataTransform {
    private static final long serialVersionUID = -2318706869393636074L;
    private int n;
    double[][] conversionArray;
    CategoricalData[] newDataArray;

    public NumericalToHistogram(DataSet dataSet) {
        this(dataSet, (int)Math.ceil(Math.sqrt(dataSet.getSampleSize())));
    }

    public NumericalToHistogram(DataSet dataSet, int n) {
        int i;
        if (n <= 0) {
            throw new RuntimeException("Must partition into a positive number of groups");
        }
        this.n = n;
        this.conversionArray = new double[dataSet.getNumNumericalVars()][2];
        double[] mins = new double[this.conversionArray.length];
        double[] maxs = new double[this.conversionArray.length];
        for (i = 0; i < mins.length; ++i) {
            mins[i] = Double.MAX_VALUE;
            maxs[i] = Double.MIN_VALUE;
        }
        for (i = 0; i < dataSet.getSampleSize(); ++i) {
            Vec v = dataSet.getDataPoint(i).getNumericalValues();
            for (int j = 0; j < mins.length; ++j) {
                mins[j] = Math.min(mins[j], v.get(j));
                maxs[j] = Math.max(maxs[j], v.get(j));
            }
        }
        for (i = 0; i < this.conversionArray.length; ++i) {
            this.conversionArray[i][0] = mins[i];
            this.conversionArray[i][1] = (maxs[i] - mins[i]) / (double)n;
        }
        this.newDataArray = new CategoricalData[dataSet.getNumNumericalVars() + dataSet.getNumCategoricalVars()];
        for (i = 0; i < dataSet.getNumNumericalVars(); ++i) {
            this.newDataArray[i] = new CategoricalData(n);
        }
        System.arraycopy(dataSet.getCategories(), 0, this.newDataArray, dataSet.getNumNumericalVars(), dataSet.getNumCategoricalVars());
    }

    private NumericalToHistogram(NumericalToHistogram other) {
        int i;
        this.n = other.n;
        this.conversionArray = new double[other.conversionArray.length][];
        for (i = 0; i < other.conversionArray.length; ++i) {
            this.conversionArray[i] = Arrays.copyOf(other.conversionArray[i], other.conversionArray[i].length);
        }
        this.newDataArray = new CategoricalData[other.newDataArray.length];
        for (i = 0; i < other.newDataArray.length; ++i) {
            this.newDataArray[i] = other.newDataArray[i].clone();
        }
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        int[] newCatVals = new int[this.newDataArray.length];
        Vec v = dp.getNumericalValues();
        for (int i = 0; i < this.conversionArray.length; ++i) {
            double val = v.get(i) - this.conversionArray[i][0];
            int catVal = (int)Math.floor(val / this.conversionArray[i][1]);
            if (catVal < 0) {
                catVal = 0;
            } else if (catVal >= this.n) {
                catVal = this.n - 1;
            }
            newCatVals[i] = catVal;
        }
        System.arraycopy(dp.getCategoricalValues(), 0, newCatVals, this.conversionArray.length, dp.numCategoricalValues());
        return new DataPoint(new DenseVector(0), newCatVals, this.newDataArray);
    }

    @Override
    public DataTransform clone() {
        return new NumericalToHistogram(this);
    }

    public static class NumericalToHistogramTransformFactory
    extends DataTransformFactoryParm {
        private int n;

        public NumericalToHistogramTransformFactory() {
            this(Integer.MAX_VALUE);
        }

        public NumericalToHistogramTransformFactory(int n) {
            this.setBins(n);
        }

        public NumericalToHistogramTransformFactory(NumericalToHistogramTransformFactory toCopy) {
            this(toCopy.n);
        }

        public void setBins(int n) {
            if (n < 1) {
                throw new IllegalArgumentException("Number of bins must be a positive value");
            }
            this.n = n;
        }

        public int getBins() {
            return this.n;
        }

        @Override
        public DataTransform getTransform(DataSet dataset) {
            if (this.n == Integer.MAX_VALUE) {
                return new NumericalToHistogram(dataset);
            }
            return new NumericalToHistogram(dataset, this.n);
        }

        @Override
        public NumericalToHistogramTransformFactory clone() {
            return new NumericalToHistogramTransformFactory(this);
        }
    }
}

