/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import jsat.DataSet;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.DataPoint;
import jsat.datatransform.DataTransform;
import jsat.datatransform.DataTransformFactory;
import jsat.linear.DenseVector;
import jsat.linear.SparseVector;
import jsat.linear.Vec;

public class NominalToNumeric
implements DataTransform {
    private static final long serialVersionUID = -7765605678836464143L;
    private final int origNumericalCount;
    private final CategoricalData[] categoricalData;
    private int addedNumers;

    public NominalToNumeric(DataSet dataSet) {
        this(dataSet.getNumNumericalVars(), dataSet.getCategories());
    }

    public NominalToNumeric(int origNumericalCount, CategoricalData[] categoricalData) {
        this.origNumericalCount = origNumericalCount;
        this.categoricalData = categoricalData;
        this.addedNumers = 0;
        for (CategoricalData cd : categoricalData) {
            this.addedNumers += cd.getNumOfCategories();
        }
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        Vec v = dp.getNumericalValues().isSparse() ? new SparseVector(this.origNumericalCount + this.addedNumers) : new DenseVector(this.origNumericalCount + this.addedNumers);
        Vec oldV = dp.getNumericalValues();
        int i = 0;
        for (i = 0; i < this.origNumericalCount; ++i) {
            v.set(i, oldV.get(i));
        }
        for (int j = 0; j < this.categoricalData.length; ++j) {
            v.set(i + dp.getCategoricalValue(j), 1.0);
            i += this.categoricalData[j].getNumOfCategories();
        }
        return new DataPoint(v, new int[0], new CategoricalData[0]);
    }

    @Override
    public NominalToNumeric clone() {
        return new NominalToNumeric(this.origNumericalCount, this.categoricalData);
    }

    public static class NominalToNumericTransformFactory
    implements DataTransformFactory {
        @Override
        public DataTransform getTransform(DataSet dataset) {
            return new NominalToNumeric(dataset);
        }

        @Override
        public NominalToNumericTransformFactory clone() {
            return new NominalToNumericTransformFactory();
        }
    }
}

