/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import java.util.Random;
import jsat.classifiers.DataPoint;
import jsat.datatransform.DataTransform;
import jsat.linear.DenseMatrix;
import jsat.linear.Matrix;
import jsat.linear.RandomMatrix;
import jsat.linear.Vec;

public class JLTransform
implements DataTransform {
    private static final long serialVersionUID = -8621368067861343912L;
    private TransformMode mode;
    private Matrix R;

    protected JLTransform(JLTransform transform) {
        this.mode = transform.mode;
        this.R = transform.R.clone();
    }

    public JLTransform(int k, int d, TransformMode mode, Random rand) {
        this(k, d, mode, rand, true);
    }

    public JLTransform(int k, int d, TransformMode mode, Random rand, boolean inMemory) {
        this.mode = mode;
        this.R = new RandomMatrixJL(k, d, rand.nextLong(), mode);
        RandomMatrixJL oldR = this.R;
        if (inMemory) {
            this.R = new DenseMatrix(k, d);
            this.R.mutableAdd(oldR);
        }
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        Vec newVec = dp.getNumericalValues();
        newVec = this.R.multiply(newVec);
        DataPoint newDP = new DataPoint(newVec, dp.getCategoricalValues(), dp.getCategoricalData(), dp.getWeight());
        return newDP;
    }

    @Override
    public DataTransform clone() {
        return new JLTransform(this);
    }

    private static class RandomMatrixJL
    extends RandomMatrix {
        private static final long serialVersionUID = 2009377824896155918L;
        private double cnst;
        private TransformMode mode;

        public RandomMatrixJL(int rows, int cols, long XORSeed, TransformMode mode) {
            super(rows, cols, XORSeed);
            this.mode = mode;
            int k = rows;
            if (mode == TransformMode.GAUSS || mode == TransformMode.BINARY) {
                this.cnst = 1.0 / Math.sqrt(k);
            } else if (mode == TransformMode.SPARSE) {
                this.cnst = Math.sqrt(3.0) / Math.sqrt(k);
            }
        }

        @Override
        protected double getVal(Random rand) {
            if (this.mode == TransformMode.GAUSS) {
                return rand.nextGaussian() * this.cnst;
            }
            if (this.mode == TransformMode.BINARY) {
                return rand.nextBoolean() ? -this.cnst : this.cnst;
            }
            if (this.mode == TransformMode.SPARSE) {
                int val = rand.nextInt(6);
                if (val == 0) {
                    return -this.cnst;
                }
                if (val == 1) {
                    return this.cnst;
                }
                return 0.0;
            }
            throw new RuntimeException("BUG: Please report");
        }
    }

    public static enum TransformMode {
        GAUSS,
        BINARY,
        SPARSE;

    }
}

