/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import java.util.ArrayList;
import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.datatransform.DataTransform;
import jsat.datatransform.DataTransformFactory;
import jsat.datatransform.InvertibleTransform;
import jsat.datatransform.WhitenedPCA;
import jsat.datatransform.ZeroMeanTransform;
import jsat.exceptions.FailedToFitException;
import jsat.linear.DenseMatrix;
import jsat.linear.DenseVector;
import jsat.linear.Matrix;
import jsat.linear.MatrixOfVecs;
import jsat.linear.SingularValueDecomposition;
import jsat.linear.Vec;

public class FastICA
implements InvertibleTransform {
    private static final long serialVersionUID = -8644025740457515563L;
    private ZeroMeanTransform zeroMean;
    private Matrix unmixing;
    private Matrix mixing;

    public FastICA(DataSet data, int C) {
        this(data, C, DefaultNegEntropyFunc.LOG_COSH, false);
    }

    public FastICA(DataSet data, int C, NegEntropyFunc G, boolean preWhitened) {
        Matrix X;
        int N = data.getSampleSize();
        DenseVector tmp = new DenseVector(N);
        ArrayList<Vec> ws = new ArrayList<Vec>(C);
        WhitenedPCA whiten = null;
        if (!preWhitened) {
            this.zeroMean = new ZeroMeanTransform(data);
            data = data.shallowClone();
            data.applyTransform(this.zeroMean);
            whiten = new WhitenedPCA(data);
            data.applyTransform(whiten);
            X = data.getDataMatrixView();
        } else {
            X = data.getDataMatrixView();
        }
        int subD = X.cols();
        DenseVector w_tmp = new DenseVector(subD);
        int maxIter = 500;
        for (int p = 0; p < C; ++p) {
            Vec w_p = Vec.random(subD);
            w_p.normalize();
            int iter = 0;
            do {
                int i;
                w_p.copyTo(w_tmp);
                tmp.zeroOut();
                X.multiply(w_p, 1.0, tmp);
                double gwx_avg = 0.0;
                for (int i2 = 0; i2 < ((Vec)tmp).length(); ++i2) {
                    double x = ((Vec)tmp).get(i2);
                    double g = G.deriv1(x);
                    double gp = G.deriv2(x, g);
                    if (Double.isNaN(g) || Double.isInfinite(g) || Double.isNaN(gp) || Double.isNaN(gp)) {
                        throw new FailedToFitException("Encountered NaN or Inf in calculation");
                    }
                    ((Vec)tmp).set(i2, g);
                    gwx_avg += gp;
                }
                w_p.mutableMultiply(-(gwx_avg /= (double)N));
                X.transposeMultiply(1.0 / (double)N, tmp, w_p);
                double[] coefs = new double[ws.size()];
                for (i = 0; i < coefs.length; ++i) {
                    coefs[i] = w_p.dot((Vec)ws.get(i));
                }
                for (i = 0; i < coefs.length; ++i) {
                    w_p.mutableAdd(-coefs[i], (Vec)ws.get(i));
                }
                w_p.normalize();
            } while (Math.abs(1.0 - Math.abs(w_p.dot(w_tmp))) > 1.0E-6 && iter++ < maxIter);
            ws.add(w_p);
        }
        if (!preWhitened) {
            MatrixOfVecs W = new MatrixOfVecs(ws);
            this.unmixing = W.multiply(whiten.transform).transpose();
        } else {
            this.unmixing = new DenseMatrix(new MatrixOfVecs(ws)).transpose();
        }
        this.mixing = new SingularValueDecomposition(this.unmixing.clone()).getPseudoInverse();
    }

    public FastICA(FastICA toCopy) {
        if (toCopy.zeroMean != null) {
            this.zeroMean = toCopy.zeroMean.clone();
        }
        if (toCopy.unmixing != null) {
            this.unmixing = toCopy.unmixing.clone();
        }
        if (toCopy.mixing != null) {
            this.mixing = toCopy.mixing.clone();
        }
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        Vec x = this.zeroMean != null ? this.zeroMean.transform(dp).getNumericalValues() : dp.getNumericalValues();
        Vec newX = x.multiply(this.unmixing);
        return new DataPoint(newX, dp.getCategoricalValues(), dp.getCategoricalData(), dp.getWeight());
    }

    @Override
    public DataPoint inverse(DataPoint dp) {
        Vec x = dp.getNumericalValues();
        x = x.multiply(this.mixing);
        DataPoint toRet = new DataPoint(x, dp.getCategoricalValues(), dp.getCategoricalData(), dp.getWeight());
        if (this.zeroMean != null) {
            this.zeroMean.mutableInverse(toRet);
        }
        return toRet;
    }

    @Override
    public FastICA clone() {
        return new FastICA(this);
    }

    public static class FastICATransformFactory
    implements DataTransformFactory {
        int C;

        public FastICATransformFactory(int C) {
            this.C = C;
        }

        @Override
        public DataTransform getTransform(DataSet dataset) {
            return new FastICA(dataset, this.C);
        }

        @Override
        public FastICATransformFactory clone() {
            return new FastICATransformFactory(this.C);
        }
    }

    public static enum DefaultNegEntropyFunc implements NegEntropyFunc
    {
        LOG_COSH{

            @Override
            public double deriv1(double x) {
                return Math.tanh(x);
            }

            @Override
            public double deriv2(double x, double d1) {
                return 1.0 - d1 * d1;
            }
        }
        ,
        EXP{

            @Override
            public double deriv1(double x) {
                return x * Math.exp(-x * x / 2.0);
            }

            @Override
            public double deriv2(double x, double d1) {
                if (x == 0.0) {
                    return 1.0;
                }
                return (1.0 - x * x) * (d1 / x);
            }
        }
        ,
        KURTOSIS{

            @Override
            public double deriv1(double x) {
                return x * x * x;
            }

            @Override
            public double deriv2(double x, double d1) {
                return x * x * 3.0;
            }
        };


        @Override
        public abstract double deriv1(double var1);

        @Override
        public abstract double deriv2(double var1, double var3);
    }

    public static interface NegEntropyFunc {
        public double deriv1(double var1);

        public double deriv2(double var1, double var3);
    }
}

