/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import java.util.Iterator;
import jsat.classifiers.DataPoint;
import jsat.datatransform.DataTransform;
import jsat.linear.DenseVector;
import jsat.linear.IndexValue;
import jsat.linear.SparseVector;
import jsat.linear.Vec;

public class DenseSparceTransform
implements DataTransform {
    private static final long serialVersionUID = -1177913691660616290L;
    private double factor;

    public DenseSparceTransform(double factor) {
        this.factor = factor;
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        Vec orig = dp.getNumericalValues();
        if (orig instanceof SparseVector) {
            SparseVector sv = (SparseVector)orig;
            if ((double)sv.nnz() / (double)sv.length() < this.factor) {
                return dp;
            }
            DenseVector dv = new DenseVector(sv.length());
            Iterator<IndexValue> iter = sv.getNonZeroIterator();
            while (iter.hasNext()) {
                IndexValue indexValue = iter.next();
                dv.set(indexValue.getIndex(), indexValue.getValue());
            }
            return new DataPoint(dv, dp.getCategoricalValues(), dp.getCategoricalData(), dp.getWeight());
        }
        int nnz = 0;
        for (int i = 0; i < orig.length(); ++i) {
            if (orig.get(i) == 0.0) continue;
            ++nnz;
        }
        if ((double)nnz / (double)orig.length() > this.factor) {
            return dp;
        }
        SparseVector sv = new SparseVector(orig.length(), nnz);
        for (int i = 0; i < orig.length(); ++i) {
            if (orig.get(i) == 0.0) continue;
            sv.set(i, orig.get(i));
        }
        return new DataPoint(sv, dp.getCategoricalValues(), dp.getCategoricalData(), dp.getWeight());
    }

    @Override
    public DenseSparceTransform clone() {
        return new DenseSparceTransform(this.factor);
    }
}

