/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import java.util.ArrayList;
import java.util.List;
import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.datatransform.DataTransform;
import jsat.datatransform.DataTransformFactory;
import jsat.datatransform.InPlaceTransform;
import jsat.datatransform.RemoveAttributeTransform;
import jsat.linear.Vec;
import jsat.parameters.Parameter;
import jsat.parameters.Parameterized;

public class DataTransformProcess
implements DataTransform,
Parameterized {
    private static final long serialVersionUID = -2844495690944305885L;
    @Parameter.ParameterHolder(skipSelfNamePrefix=true)
    private List<DataTransformFactory> transformSource = new ArrayList<DataTransformFactory>();
    private List<DataTransform> learnedTransforms = new ArrayList<DataTransform>();

    public DataTransformProcess() {
    }

    public DataTransformProcess(DataTransformFactory ... factories) {
        this();
        for (DataTransformFactory factory : factories) {
            this.addTransform(factory);
        }
    }

    public void addTransform(DataTransformFactory transform) {
        this.transformSource.add(transform);
    }

    public int getNumberOfTransforms() {
        return this.transformSource.size();
    }

    private void consolidateTransforms() {
        for (int i = 0; i < this.learnedTransforms.size() - 1; ++i) {
            DataTransform t1 = this.learnedTransforms.get(i);
            DataTransform t2 = this.learnedTransforms.get(i + 1);
            if (!(t1 instanceof RemoveAttributeTransform) || !(t2 instanceof RemoveAttributeTransform)) continue;
            RemoveAttributeTransform r1 = (RemoveAttributeTransform)t1;
            RemoveAttributeTransform r2 = (RemoveAttributeTransform)t2;
            r2.consolidate(r1);
            this.learnedTransforms.remove(i);
            --i;
        }
    }

    public void leanTransforms(DataSet dataSet) {
        this.learnApplyTransforms(dataSet.shallowClone());
    }

    public void learnApplyTransforms(DataSet dataSet) {
        this.learnedTransforms.clear();
        boolean vecSafe = false;
        boolean catSafe = false;
        int iter = 0;
        Vec[] origVecs = new Vec[dataSet.getSampleSize()];
        int[][] origCats = new int[dataSet.getSampleSize()][];
        for (int i = 0; i < origVecs.length; ++i) {
            DataPoint dp = dataSet.getDataPoint(i);
            origVecs[i] = dp.getNumericalValues();
            origCats[i] = dp.getCategoricalValues();
        }
        for (DataTransformFactory dtf : this.transformSource) {
            DataTransform transform = dtf.getTransform(dataSet);
            if (transform instanceof InPlaceTransform) {
                InPlaceTransform ipt = (InPlaceTransform)transform;
                if (iter > 0 && !vecSafe || ipt.mutatesNominal() && !catSafe) {
                    boolean vecClear = true;
                    boolean catClear = true;
                    for (int i = 0; i < origVecs.length && (vecClear || catClear); ++i) {
                        DataPoint dp = dataSet.getDataPoint(i);
                        vecClear = origVecs[i] != dp.getNumericalValues();
                        catClear = origCats[i] != dp.getCategoricalValues();
                    }
                    vecSafe = vecClear;
                    catSafe = catClear;
                }
                if (vecSafe && (!ipt.mutatesNominal() || catSafe)) {
                    dataSet.applyTransform((DataTransform)ipt, true);
                } else {
                    dataSet.applyTransform(transform);
                }
            } else {
                dataSet.applyTransform(transform);
            }
            this.learnedTransforms.add(transform);
            ++iter;
        }
        this.consolidateTransforms();
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        Vec origNum = dp.getNumericalValues();
        int[] origCat = dp.getCategoricalValues();
        for (DataTransform dt : this.learnedTransforms) {
            if (dt instanceof InPlaceTransform) {
                InPlaceTransform it = (InPlaceTransform)dt;
                if (!(origNum == dp.getNumericalValues() || it.mutatesNominal() && origCat == dp.getCategoricalValues())) {
                    it.mutableTransform(dp);
                    continue;
                }
            }
            dp = dt.transform(dp);
        }
        return dp;
    }

    @Override
    public DataTransformProcess clone() {
        DataTransformProcess clone = new DataTransformProcess();
        for (DataTransformFactory dtf : this.transformSource) {
            clone.transformSource.add(dtf.clone());
        }
        for (DataTransform dt : this.learnedTransforms) {
            clone.learnedTransforms.add(dt.clone());
        }
        return clone;
    }

    @Override
    public List<Parameter> getParameters() {
        return Parameter.getParamsFromMethods(this);
    }

    @Override
    public Parameter getParameter(String paramName) {
        return Parameter.toParameterMap(this.getParameters()).get(paramName);
    }
}

