/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.kmeans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsat.DataSet;
import jsat.clustering.SeedSelectionMethods;
import jsat.clustering.kmeans.KMeans;
import jsat.linear.DenseVector;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.distancemetrics.TrainableDistanceMetric;
import jsat.utils.FakeExecutor;
import jsat.utils.SystemInfo;
import jsat.utils.random.XORWOW;

public class NaiveKMeans
extends KMeans {
    private static final long serialVersionUID = 6164910874898843069L;

    public NaiveKMeans() {
        this(new EuclideanDistance());
    }

    public NaiveKMeans(DistanceMetric dm) {
        this(dm, SeedSelectionMethods.SeedSelection.KPP);
    }

    public NaiveKMeans(DistanceMetric dm, SeedSelectionMethods.SeedSelection seedSelection) {
        this(dm, seedSelection, new XORWOW());
    }

    public NaiveKMeans(DistanceMetric dm, SeedSelectionMethods.SeedSelection seedSelection, Random rand) {
        super(dm, seedSelection, rand);
    }

    public NaiveKMeans(NaiveKMeans toCopy) {
        super(toCopy);
    }

    @Override
    protected double cluster(DataSet dataSet, List<Double> accelCacheInit, final int k, final List<Vec> means, final int[] assignment, boolean exactTotal, ExecutorService threadpool, boolean returnError) {
        TrainableDistanceMetric.trainIfNeeded(this.dm, dataSet, threadpool);
        if (threadpool == null) {
            threadpool = new FakeExecutor();
        }
        int blockSize = dataSet.getSampleSize() / SystemInfo.LogicalCores;
        final List<Vec> X = dataSet.getDataVectors();
        final List<Double> accelCache = accelCacheInit == null ? (threadpool instanceof FakeExecutor ? this.dm.getAccelerationCache(X) : this.dm.getAccelerationCache(X, threadpool)) : accelCacheInit;
        if (means.size() != k) {
            means.clear();
            if (threadpool instanceof FakeExecutor) {
                means.addAll(SeedSelectionMethods.selectIntialPoints(dataSet, k, this.dm, accelCache, this.rand, this.seedSelection));
            } else {
                means.addAll(SeedSelectionMethods.selectIntialPoints(dataSet, k, this.dm, accelCache, this.rand, this.seedSelection, threadpool));
            }
        }
        final ArrayList<List<Double>> meanQIs = new ArrayList<List<Double>>(k);
        for (int i = 0; i < means.size(); ++i) {
            if (this.dm.supportsAcceleration()) {
                meanQIs.add(this.dm.getQueryInfo(means.get(i)));
            } else {
                meanQIs.add(Collections.EMPTY_LIST);
            }
            if (!means.get(i).isSparse()) continue;
            means.set(i, new DenseVector(means.get(i)));
        }
        final ArrayList<DenseVector> meanSum = new ArrayList<DenseVector>(means.size());
        final AtomicIntegerArray meanCounts = new AtomicIntegerArray(means.size());
        for (int i = 0; i < k; ++i) {
            meanSum.add(new DenseVector(means.get(0).length()));
        }
        final AtomicInteger changes = new AtomicInteger();
        final ThreadLocal<Vec[]> localMeanDeltas = new ThreadLocal<Vec[]>(){

            @Override
            protected Vec[] initialValue() {
                Vec[] deltas = new Vec[k];
                for (int i = 0; i < k; ++i) {
                    deltas[i] = new DenseVector(((Vec)means.get(0)).length());
                }
                return deltas;
            }
        };
        Arrays.fill(assignment, -1);
        do {
            changes.set(0);
            int extra = dataSet.getSampleSize() % SystemInfo.LogicalCores;
            int start = 0;
            final CountDownLatch latch = new CountDownLatch(SystemInfo.LogicalCores);
            while (start < dataSet.getSampleSize()) {
                final int s = start;
                final int end = start + blockSize + (extra-- > 0 ? 1 : 0);
                threadpool.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        int i;
                        Vec[] deltas = (Vec[])localMeanDeltas.get();
                        for (i = s; i < end; ++i) {
                            Vec x = (Vec)X.get(i);
                            double minDist = Double.POSITIVE_INFINITY;
                            int min = -1;
                            for (int j = 0; j < means.size(); ++j) {
                                double tmp = NaiveKMeans.this.dm.dist(i, (Vec)means.get(j), (List)meanQIs.get(j), X, accelCache);
                                if (!(tmp < minDist)) continue;
                                minDist = tmp;
                                min = j;
                            }
                            if (assignment[i] == min) continue;
                            deltas[min].mutableAdd(x);
                            meanCounts.incrementAndGet(min);
                            if (assignment[i] >= 0) {
                                deltas[assignment[i]].mutableSubtract(x);
                                meanCounts.getAndDecrement(assignment[i]);
                            }
                            assignment[i] = min;
                            changes.incrementAndGet();
                        }
                        for (i = 0; i < deltas.length; ++i) {
                            Vec vec = (Vec)meanSum.get(i);
                            synchronized (vec) {
                                ((Vec)meanSum.get(i)).mutableAdd(deltas[i]);
                                deltas[i].zeroOut();
                                continue;
                            }
                        }
                        latch.countDown();
                    }
                });
                start = end;
            }
            try {
                latch.await();
                if (changes.get() == 0) break;
                for (int i = 0; i < k; ++i) {
                    ((Vec)meanSum.get(i)).copyTo(means.get(i));
                    means.get(i).mutableDivide(meanCounts.get(i));
                    if (!this.dm.supportsAcceleration()) continue;
                    meanQIs.set(i, this.dm.getQueryInfo(means.get(i)));
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(NaiveKMeans.class.getName()).log(Level.SEVERE, null, ex);
            }
        } while (changes.get() > 0);
        if (returnError) {
            double totalDistance = 0.0;
            this.nearestCentroidDist = (double[])(this.saveCentroidDistance ? new double[X.size()] : null);
            for (int i = 0; i < dataSet.getSampleSize(); ++i) {
                double dist = this.dm.dist(i, means.get(assignment[i]), (List)meanQIs.get(assignment[i]), X, accelCache);
                totalDistance += Math.pow(dist, 2.0);
                if (!this.saveCentroidDistance) continue;
                this.nearestCentroidDist[i] = dist;
            }
            return totalDistance;
        }
        return 0.0;
    }

    @Override
    public NaiveKMeans clone() {
        return new NaiveKMeans(this);
    }
}

