/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.kmeans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import jsat.DataSet;
import jsat.clustering.kmeans.HamerlyKMeans;
import jsat.clustering.kmeans.KMeans;
import jsat.linear.Vec;

public class KMeansPDN
extends KMeans {
    private static final long serialVersionUID = -2358377567814606959L;
    private KMeans kmeans;
    private double[] fKs;

    public KMeansPDN() {
        this(new HamerlyKMeans());
    }

    public KMeansPDN(KMeans kmeans) {
        super(kmeans.dm, kmeans.seedSelection, kmeans.rand);
        this.kmeans = kmeans;
    }

    public KMeansPDN(KMeansPDN toCopy) {
        super(toCopy);
        this.kmeans = toCopy.kmeans.clone();
        if (toCopy.fKs != null) {
            this.fKs = Arrays.copyOf(toCopy.fKs, toCopy.fKs.length);
        }
    }

    public double[] getfKs() {
        return this.fKs;
    }

    @Override
    public int[] cluster(DataSet dataSet, int[] designations) {
        return this.cluster(dataSet, null, designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, ExecutorService threadpool, int[] designations) {
        return this.cluster(dataSet, 1, (int)Math.min(Math.max(Math.sqrt(dataSet.getSampleSize()), 10.0), 100.0), threadpool, designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, int lowK, int highK, ExecutorService threadpool, int[] designations) {
        double minFk;
        if (highK == lowK) {
            return this.cluster(dataSet, lowK, threadpool, designations);
        }
        if (highK < lowK) {
            throw new IllegalArgumentException("low value of k (" + lowK + ") must be higher than the high value of k(" + highK + ")");
        }
        int N = dataSet.getSampleSize();
        int D = dataSet.getNumNumericalVars();
        this.fKs = new double[highK - 1];
        this.fKs[0] = 1.0;
        int[] bestCluster = new int[N];
        double d = minFk = lowK == 1 ? 1.0 : Double.POSITIVE_INFINITY;
        if (designations == null || designations.length < N) {
            designations = new int[N];
        }
        double alphaKprev = 0.0;
        double S_k_prev = 0.0;
        ArrayList<Vec> curMeans = new ArrayList<Vec>(highK);
        this.means = new ArrayList();
        List<Double> accelCache = this.dm.getAccelerationCache(dataSet.getDataVectors(), threadpool);
        for (int k = 2; k < highK; ++k) {
            double fK;
            curMeans.clear();
            double S_k = this.cluster(dataSet, accelCache, k, curMeans, designations, true, threadpool, true);
            double alpha_k = k == 2 ? 1.0 - 3.0 / (double)(4 * D) : alphaKprev + (1.0 - alphaKprev) / 6.0;
            if (S_k_prev == 0.0) {
                fK = 1.0;
                this.fKs[k - 1] = 1.0;
            } else {
                this.fKs[k - 1] = fK = S_k / (alpha_k * S_k_prev);
            }
            alphaKprev = alpha_k;
            S_k_prev = S_k;
            if (k < lowK || !(minFk > fK)) continue;
            System.arraycopy(designations, 0, bestCluster, 0, N);
            minFk = fK;
            this.means.clear();
            for (Vec mean : curMeans) {
                this.means.add(mean.clone());
            }
        }
        System.arraycopy(bestCluster, 0, designations, 0, N);
        return designations;
    }

    @Override
    public int[] cluster(DataSet dataSet, int lowK, int highK, int[] designations) {
        return this.cluster(dataSet, lowK, highK, null, designations);
    }

    @Override
    protected double cluster(DataSet dataSet, List<Double> accelCache, int k, List<Vec> means, int[] assignment, boolean exactTotal, ExecutorService threadpool, boolean returnError) {
        return this.kmeans.cluster(dataSet, accelCache, k, means, assignment, exactTotal, threadpool, returnError);
    }

    @Override
    public KMeansPDN clone() {
        return new KMeansPDN(this);
    }
}

