/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.kmeans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsat.DataSet;
import jsat.clustering.ClusterFailureException;
import jsat.clustering.kmeans.KernelKMeans;
import jsat.distributions.kernels.KernelTrick;
import jsat.utils.SystemInfo;
import jsat.utils.concurrent.ParallelUtils;

public class ElkanKernelKMeans
extends KernelKMeans {
    private static final long serialVersionUID = 4998832201379993827L;

    public ElkanKernelKMeans(KernelTrick kernel) {
        super(kernel);
    }

    public ElkanKernelKMeans(ElkanKernelKMeans toCopy) {
        super(toCopy);
    }

    protected double cluster(DataSet dataSet, final int k, final int[] assignment, boolean exactTotal, ExecutorService threadpool) {
        try {
            int i;
            final int N = dataSet.getSampleSize();
            if (N < k) {
                throw new ClusterFailureException("Fewer data points then desired clusters, decrease cluster size");
            }
            this.X = dataSet.getDataVectors();
            this.setup(k, assignment);
            final double[][] lowerBound = new double[N][k];
            final double[] upperBound = new double[N];
            final double[][] centroidSelfDistances = new double[k][k];
            final double[] sC = new double[k];
            this.calculateCentroidDistances(k, centroidSelfDistances, sC, assignment, threadpool);
            int atLeast = 2;
            final AtomicBoolean changeOccurred = new AtomicBoolean(true);
            final boolean[] r = new boolean[N];
            if (threadpool == null) {
                this.initialClusterSetUp(k, N, lowerBound, upperBound, centroidSelfDistances, assignment);
            } else {
                this.initialClusterSetUp(k, N, lowerBound, upperBound, centroidSelfDistances, assignment, threadpool);
            }
            int iterLimit = this.maximumIterations;
            while ((changeOccurred.get() || atLeast > 0) && iterLimit-- >= 0) {
                --atLeast;
                changeOccurred.set(false);
                if (iterLimit < this.maximumIterations - 1) {
                    this.calculateCentroidDistances(k, centroidSelfDistances, sC, assignment, threadpool);
                }
                final CountDownLatch latch = new CountDownLatch(SystemInfo.LogicalCores);
                if (threadpool == null) {
                    for (int q = 0; q < N; ++q) {
                        if (upperBound[q] <= sC[assignment[q]]) continue;
                        for (int c = 0; c < k; ++c) {
                            if (c == assignment[q] || !(upperBound[q] > lowerBound[q][c]) || !(upperBound[q] > centroidSelfDistances[assignment[q]][c] * 0.5)) continue;
                            this.step3aBoundsUpdate(r, q, assignment, upperBound, lowerBound);
                            this.step3bUpdate(upperBound, q, lowerBound, c, centroidSelfDistances, assignment, changeOccurred);
                        }
                    }
                } else {
                    int id = 0;
                    while (id < SystemInfo.LogicalCores) {
                        final int ID = id++;
                        threadpool.submit(new Runnable(){

                            @Override
                            public void run() {
                                for (int q = ID; q < N; q += SystemInfo.LogicalCores) {
                                    if (upperBound[q] <= sC[assignment[q]]) continue;
                                    for (int c = 0; c < k; ++c) {
                                        if (c == assignment[q] || !(upperBound[q] > lowerBound[q][c]) || !(upperBound[q] > centroidSelfDistances[assignment[q]][c] * 0.5)) continue;
                                        ElkanKernelKMeans.this.step3aBoundsUpdate(r, q, assignment, upperBound, lowerBound);
                                        ElkanKernelKMeans.this.step3bUpdate(upperBound, q, lowerBound, c, centroidSelfDistances, assignment, changeOccurred);
                                    }
                                }
                                latch.countDown();
                            }
                        });
                    }
                }
                if (threadpool != null) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException ex) {
                        throw new ClusterFailureException("Clustering failed");
                    }
                }
                int moved = this.step4_5_6_distanceMovedBoundsUpdate(k, N, lowerBound, upperBound, assignment, r, threadpool);
            }
            double totalDistance = 0.0;
            if (exactTotal) {
                for (i = 0; i < N; ++i) {
                    totalDistance += Math.pow(upperBound[i], 2.0);
                }
            } else {
                for (i = 0; i < N; ++i) {
                    totalDistance += Math.pow(upperBound[i], 2.0);
                }
            }
            return totalDistance;
        }
        catch (Exception ex) {
            Logger.getLogger(ElkanKernelKMeans.class.getName()).log(Level.SEVERE, null, ex);
            return Double.MAX_VALUE;
        }
    }

    private void initialClusterSetUp(int k, int N, double[][] lowerBound, double[] upperBound, double[][] centroidSelfDistances, int[] assignment) {
        boolean[] skip = new boolean[k];
        for (int q = 0; q < N; ++q) {
            double minDistance = Double.MAX_VALUE;
            int index = -1;
            Arrays.fill(skip, false);
            for (int i = 0; i < k; ++i) {
                double d;
                if (skip[i]) continue;
                lowerBound[q][i] = d = this.distance(q, i, assignment);
                if (!(d < minDistance)) continue;
                minDistance = upperBound[q] = d;
                index = i;
                for (int z = i + 1; z < k; ++z) {
                    if (!(centroidSelfDistances[i][z] >= 2.0 * d)) continue;
                    skip[z] = true;
                }
            }
            this.newDesignations[q] = index;
        }
    }

    private void initialClusterSetUp(final int k, int N, final double[][] lowerBound, final double[] upperBound, final double[][] centroidSelfDistances, final int[] assignment, ExecutorService threadpool) {
        int blockSize = N / SystemInfo.LogicalCores;
        int extra = N % SystemInfo.LogicalCores;
        int pos = 0;
        final CountDownLatch latch = new CountDownLatch(SystemInfo.LogicalCores);
        while (pos < N) {
            int to;
            final int from = pos;
            pos = to = pos + blockSize + (extra-- > 0 ? 1 : 0);
            threadpool.submit(new Runnable(){

                @Override
                public void run() {
                    boolean[] skip = new boolean[k];
                    for (int q = from; q < to; ++q) {
                        double minDistance = Double.MAX_VALUE;
                        int index = -1;
                        Arrays.fill(skip, false);
                        for (int i = 0; i < k; ++i) {
                            double d;
                            if (skip[i]) continue;
                            lowerBound[q][i] = d = ElkanKernelKMeans.this.distance(q, i, assignment);
                            if (!(d < minDistance)) continue;
                            minDistance = upperBound[q] = d;
                            index = i;
                            for (int z = i + 1; z < k; ++z) {
                                if (!(centroidSelfDistances[i][z] >= 2.0 * d)) continue;
                                skip[z] = true;
                            }
                        }
                        ElkanKernelKMeans.this.newDesignations[q] = index;
                    }
                    latch.countDown();
                }
            });
        }
        while (pos++ < SystemInfo.LogicalCores) {
            latch.countDown();
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ElkanKernelKMeans.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int step4_5_6_distanceMovedBoundsUpdate(final int k, int N, double[][] lowerBound, final double[] upperBound, final int[] assignment, final boolean[] r, ExecutorService threadpool) {
        int i;
        final double[] distancesMoved = new double[k];
        double[] oldSqrdNorms = new double[this.meanSqrdNorms.length];
        for (int i2 = 0; i2 < this.meanSqrdNorms.length; ++i2) {
            oldSqrdNorms[i2] = this.meanSqrdNorms[i2] * this.normConsts[i2];
        }
        int moved = 0;
        if (threadpool != null) {
            try {
                void var13_21;
                ArrayList<Future<Integer>> futureChanges = new ArrayList<Future<Integer>>(SystemInfo.LogicalCores);
                for (int id = 0; id < SystemInfo.LogicalCores; ++id) {
                    final int n = ParallelUtils.getStartBlock(N, id, SystemInfo.LogicalCores);
                    final int end = ParallelUtils.getEndBlock(N, id, SystemInfo.LogicalCores);
                    futureChanges.add(threadpool.submit(new Callable<Integer>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Integer call() {
                            double[] sqrdChange = new double[k];
                            int[] ownerChange = new int[k];
                            int localChange = 0;
                            for (int q = n; q < end; ++q) {
                                localChange += ElkanKernelKMeans.this.updateMeansFromChange(q, assignment, sqrdChange, ownerChange);
                            }
                            int[] nArray = assignment;
                            synchronized (assignment) {
                                ElkanKernelKMeans.this.applyMeanUpdates(sqrdChange, ownerChange);
                                // ** MonitorExit[var4_5] (shouldn't be in output)
                                return localChange;
                            }
                        }
                    }));
                }
                try {
                    for (Future future : futureChanges) {
                        moved += ((Integer)future.get()).intValue();
                    }
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(ElkanKernelKMeans.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.updateNormConsts();
                CountDownLatch latch2 = new CountDownLatch(k);
                boolean bl = false;
                while (var13_21 < k) {
                    void c = var13_21++;
                    threadpool.submit(new Runnable((int)c, assignment, oldSqrdNorms, N, lowerBound, latch2){
                        final /* synthetic */ int val$c;
                        final /* synthetic */ int[] val$assignment;
                        final /* synthetic */ double[] val$oldSqrdNorms;
                        final /* synthetic */ int val$N;
                        final /* synthetic */ double[][] val$lowerBound;
                        final /* synthetic */ CountDownLatch val$latch2;
                        {
                            this.val$c = n;
                            this.val$assignment = nArray;
                            this.val$oldSqrdNorms = dArray2;
                            this.val$N = n2;
                            this.val$lowerBound = dArray3;
                            this.val$latch2 = countDownLatch;
                        }

                        @Override
                        public void run() {
                            distancesMoved[this.val$c] = ElkanKernelKMeans.this.meanToMeanDistance(this.val$c, this.val$c, ElkanKernelKMeans.this.newDesignations, this.val$assignment, this.val$oldSqrdNorms[this.val$c]);
                            for (int q = 0; q < this.val$N; ++q) {
                                this.val$lowerBound[q][this.val$c] = Math.max(this.val$lowerBound[q][this.val$c] - distancesMoved[this.val$c], 0.0);
                            }
                            this.val$latch2.countDown();
                        }
                    });
                }
                latch2.await();
                System.arraycopy(this.newDesignations, 0, assignment, 0, N);
                final CountDownLatch countDownLatch = new CountDownLatch(SystemInfo.LogicalCores);
                for (int id = 0; id < SystemInfo.LogicalCores; ++id) {
                    final int start = ParallelUtils.getStartBlock(N, id, SystemInfo.LogicalCores);
                    final int end = ParallelUtils.getEndBlock(N, id, SystemInfo.LogicalCores);
                    threadpool.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int q = start; q < end; ++q) {
                                int n = q;
                                upperBound[n] = upperBound[n] + distancesMoved[assignment[q]];
                                r[q] = true;
                            }
                            countDownLatch.countDown();
                        }
                    });
                }
                countDownLatch.await();
                return moved;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ElkanKernelKMeans.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        for (i = 0; i < N; ++i) {
            moved += this.updateMeansFromChange(i, assignment);
        }
        this.updateNormConsts();
        for (i = 0; i < k; ++i) {
            distancesMoved[i] = this.meanToMeanDistance(i, i, this.newDesignations, assignment, oldSqrdNorms[i]);
        }
        System.arraycopy(this.newDesignations, 0, assignment, 0, N);
        for (int c = 0; c < k; ++c) {
            for (int q = 0; q < N; ++q) {
                lowerBound[q][c] = Math.max(lowerBound[q][c] - distancesMoved[c], 0.0);
            }
        }
        for (int q = 0; q < N; ++q) {
            int n = q;
            upperBound[n] = upperBound[n] + distancesMoved[assignment[q]];
            r[q] = true;
        }
        return moved;
    }

    private void step3aBoundsUpdate(boolean[] r, int q, int[] assignment, double[] upperBound, double[][] lowerBound) {
        if (r[q]) {
            double d;
            r[q] = false;
            int meanIndx = assignment[q];
            lowerBound[q][meanIndx] = d = this.distance(q, meanIndx, assignment);
            upperBound[q] = d;
        }
    }

    private void step3bUpdate(double[] upperBound, int q, double[][] lowerBound, int c, double[][] centroidSelfDistances, int[] assignment, AtomicBoolean changeOccurred) {
        if (upperBound[q] > lowerBound[q][c] || upperBound[q] > centroidSelfDistances[assignment[q]][c] / 2.0) {
            double d;
            lowerBound[q][c] = d = this.distance(q, c, assignment);
            if (d < upperBound[q]) {
                this.newDesignations[q] = c;
                upperBound[q] = d;
                changeOccurred.set(true);
            }
        }
    }

    private void calculateCentroidDistances(int k, final double[][] centroidSelfDistances, double[] sC, final int[] curAssignments, ExecutorService threadpool) {
        int i;
        if (threadpool != null) {
            int jobs = (1 + k) * k / 2 - k;
            final CountDownLatch latch = new CountDownLatch(jobs);
            for (int i2 = 0; i2 < k; ++i2) {
                final int ii = i2;
                int z = i2 + 1;
                while (z < k) {
                    centroidSelfDistances[i2][i2] = 0.0;
                    final int zz = z++;
                    threadpool.submit(new Runnable(){

                        @Override
                        public void run() {
                            double d = ElkanKernelKMeans.this.meanToMeanDistance(ii, zz, curAssignments);
                            centroidSelfDistances[zz][ii] = d;
                            centroidSelfDistances[ii][zz] = d;
                            latch.countDown();
                        }
                    });
                }
            }
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ElkanKernelKMeans.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int i3 = 0; i3 < k; ++i3) {
                double sCmin = Double.MAX_VALUE;
                for (int z = 0; z < k; ++z) {
                    if (i3 == z) continue;
                    sCmin = Math.min(sCmin, centroidSelfDistances[i3][z]);
                }
                sC[i3] = sCmin / 2.0;
            }
            return;
        }
        for (i = 0; i < k; ++i) {
            for (int z = i + 1; z < k; ++z) {
                double d = this.meanToMeanDistance(i, z, curAssignments);
                centroidSelfDistances[i][z] = d;
                centroidSelfDistances[z][i] = d;
            }
        }
        for (i = 0; i < k; ++i) {
            double sCmin = Double.MAX_VALUE;
            for (int z = 0; z < k; ++z) {
                if (i == z) continue;
                sCmin = Math.min(sCmin, centroidSelfDistances[i][z]);
            }
            sC[i] = sCmin / 2.0;
        }
    }

    @Override
    public int[] cluster(DataSet dataSet, int clusters, ExecutorService threadpool, int[] designations) {
        if (designations == null) {
            designations = new int[dataSet.getSampleSize()];
        }
        if (dataSet.getSampleSize() < clusters) {
            throw new ClusterFailureException("Fewer data points then desired clusters, decrease cluster size");
        }
        this.cluster(dataSet, clusters, designations, false, threadpool);
        return designations;
    }

    @Override
    public int[] cluster(DataSet dataSet, int clusters, int[] designations) {
        if (designations == null) {
            designations = new int[dataSet.getSampleSize()];
        }
        if (dataSet.getSampleSize() < clusters) {
            throw new ClusterFailureException("Fewer data points then desired clusters, decrease cluster size");
        }
        this.cluster(dataSet, clusters, designations, false, null);
        return designations;
    }

    @Override
    public ElkanKernelKMeans clone() {
        return new ElkanKernelKMeans(this);
    }
}

