/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.evaluation;

import java.util.List;
import jsat.DataSet;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.DataPoint;
import jsat.clustering.evaluation.ClusterEvaluation;
import jsat.utils.DoubleList;

public class NormalizedMutualInformation
implements ClusterEvaluation {
    @Override
    public double evaluate(int[] designations, DataSet dataSet) {
        int i;
        int i2;
        if (!(dataSet instanceof ClassificationDataSet)) {
            throw new RuntimeException("NMI can only be calcuate for classification data sets");
        }
        ClassificationDataSet cds = (ClassificationDataSet)dataSet;
        double nmiNumer = 0.0;
        double nmiC = 0.0;
        double nmiK = 0.0;
        DoubleList kPriors = new DoubleList();
        for (int i3 = 0; i3 < cds.getSampleSize(); ++i3) {
            int ki = designations[i3];
            if (ki < 0) continue;
            while (kPriors.size() <= ki) {
                kPriors.add(0.0);
            }
            kPriors.set(ki, kPriors.get(ki) + cds.getDataPoint(i3).getWeight());
        }
        double N = 0.0;
        for (i2 = 0; i2 < kPriors.size(); ++i2) {
            N += kPriors.get(i2).doubleValue();
        }
        for (i2 = 0; i2 < kPriors.size(); ++i2) {
            kPriors.set(i2, kPriors.get(i2) / N);
            double pKi = kPriors.get(i2);
            if (!(pKi > 0.0)) continue;
            nmiK += -pKi * Math.log(pKi);
        }
        double[] cPriors = cds.getPriors();
        double[][] ck = new double[cPriors.length][kPriors.size()];
        for (i = 0; i < cds.getSampleSize(); ++i) {
            int ci = cds.getDataPointCategory(i);
            int kj = designations[i];
            if (kj < 0) continue;
            double[] dArray = ck[ci];
            int n = kj;
            dArray[n] = dArray[n] + cds.getDataPoint(i).getWeight();
        }
        for (i = 0; i < cPriors.length; ++i) {
            double pCi = cPriors[i];
            if (pCi <= 0.0) continue;
            double logPCi = Math.log(pCi);
            for (int j = 0; j < kPriors.size(); ++j) {
                double pCiKj;
                double pKj = kPriors.get(j);
                if (pKj <= 0.0 || (pCiKj = ck[i][j] / N) <= 0.0) continue;
                nmiNumer += pCiKj * (Math.log(pCiKj) - Math.log(pKj) - logPCi);
            }
            nmiC += -pCi * logPCi;
        }
        return 1.0 - nmiNumer / ((nmiC + nmiK) / 2.0);
    }

    @Override
    public double evaluate(List<List<DataPoint>> dataSets) {
        throw new UnsupportedOperationException("NMI requires the true data set labels, call evaluate(int[] designations, DataSet dataSet) instead");
    }

    @Override
    public NormalizedMutualInformation clone() {
        return new NormalizedMutualInformation();
    }
}

