/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.dissimilarity;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jsat.classifiers.DataPoint;
import jsat.clustering.dissimilarity.DistanceMetricDissimilarity;
import jsat.clustering.dissimilarity.UpdatableClusterDissimilarity;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.utils.IntSet;

public abstract class LanceWilliamsDissimilarity
extends DistanceMetricDissimilarity
implements UpdatableClusterDissimilarity {
    public LanceWilliamsDissimilarity(DistanceMetric dm) {
        super(dm);
    }

    public LanceWilliamsDissimilarity(LanceWilliamsDissimilarity toCopy) {
        this(toCopy.dm.clone());
    }

    protected abstract double aConst(boolean var1, int var2, int var3, int var4);

    protected abstract double bConst(int var1, int var2, int var3);

    protected abstract double cConst(int var1, int var2, int var3);

    @Override
    public double dissimilarity(List<DataPoint> a, List<DataPoint> b) {
        List<DataPoint> CK;
        List<DataPoint> CJ;
        List<DataPoint> CI;
        if (a.size() == 1 && b.size() == 1) {
            return this.dm.dist(a.get(0).getNumericalValues(), b.get(0).getNumericalValues());
        }
        if (a.size() > 1) {
            CI = a.subList(0, 1);
            CJ = a.subList(1, a.size());
            CK = b;
        } else {
            CI = b.subList(0, 1);
            CJ = b.subList(1, b.size());
            CK = a;
        }
        double d_ik = this.dissimilarity(CI, CK);
        double d_jk = this.dissimilarity(CJ, CK);
        double d_ij = this.dissimilarity(CI, CJ);
        return this.aConst(true, CI.size(), CJ.size(), CK.size()) * d_ik + this.aConst(false, CI.size(), CJ.size(), CK.size()) * d_jk + this.bConst(CI.size(), CJ.size(), CK.size()) * d_ij + this.cConst(CI.size(), CJ.size(), CK.size()) * Math.abs(d_ik - d_jk);
    }

    @Override
    public double dissimilarity(Set<Integer> a, Set<Integer> b, double[][] distanceMatrix) {
        Set<Integer> CK;
        IntSet CJ;
        IntSet CI;
        if (a.size() == 1 && b.size() == 1) {
            return LanceWilliamsDissimilarity.getDistance(distanceMatrix, LanceWilliamsDissimilarity.getVal(a), LanceWilliamsDissimilarity.getVal(b));
        }
        if (a.size() > 1) {
            CI = new IntSet();
            CI.add(LanceWilliamsDissimilarity.getVal(a));
            CJ = new IntSet(a);
            CJ.removeAll(CI);
            CK = b;
        } else {
            CI = new IntSet();
            CI.add(LanceWilliamsDissimilarity.getVal(b));
            CJ = new IntSet(b);
            CJ.removeAll(CI);
            CK = a;
        }
        double d_ik = this.dissimilarity(CI, CK, distanceMatrix);
        double d_jk = this.dissimilarity(CJ, CK, distanceMatrix);
        double d_ij = this.dissimilarity(CI, CJ, distanceMatrix);
        return this.aConst(true, CI.size(), CJ.size(), CK.size()) * d_ik + this.aConst(false, CI.size(), CJ.size(), CK.size()) * d_jk + this.bConst(CI.size(), CJ.size(), CK.size()) * d_ij + this.cConst(CI.size(), CJ.size(), CK.size()) * Math.abs(d_ik - d_jk);
    }

    private static int getVal(Set<Integer> a) {
        Iterator<Integer> i$ = a.iterator();
        if (i$.hasNext()) {
            int i = i$.next();
            return i;
        }
        return -1;
    }

    @Override
    public double dissimilarity(int i, int ni, int j, int nj, double[][] distanceMatrix) {
        return LanceWilliamsDissimilarity.getDistance(distanceMatrix, i, j);
    }

    @Override
    public double dissimilarity(int i, int ni, int j, int nj, int k, int nk, double[][] distanceMatrix) {
        double d_ik = LanceWilliamsDissimilarity.getDistance(distanceMatrix, i, k);
        double d_jk = LanceWilliamsDissimilarity.getDistance(distanceMatrix, j, k);
        double d_ij = LanceWilliamsDissimilarity.getDistance(distanceMatrix, i, j);
        return this.aConst(true, ni, nj, nk) * d_ik + this.aConst(false, ni, nj, nk) * d_jk + this.bConst(ni, nj, nk) * d_ij + this.cConst(ni, nj, nk) * Math.abs(d_ik - d_jk);
    }

    @Override
    public abstract LanceWilliamsDissimilarity clone();
}

