/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.dissimilarity;

import java.util.List;
import java.util.Set;
import jsat.classifiers.DataPoint;
import jsat.clustering.dissimilarity.DistanceMetricDissimilarity;
import jsat.clustering.dissimilarity.UpdatableClusterDissimilarity;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;

public class CompleteLinkDissimilarity
extends DistanceMetricDissimilarity
implements UpdatableClusterDissimilarity {
    public CompleteLinkDissimilarity() {
        this(new EuclideanDistance());
    }

    public CompleteLinkDissimilarity(DistanceMetric dm) {
        super(dm);
    }

    public CompleteLinkDissimilarity(CompleteLinkDissimilarity toCopy) {
        this(toCopy.dm.clone());
    }

    @Override
    public CompleteLinkDissimilarity clone() {
        return new CompleteLinkDissimilarity(this);
    }

    @Override
    public double dissimilarity(List<DataPoint> a, List<DataPoint> b) {
        double maxDiss = Double.MIN_VALUE;
        for (DataPoint ai : a) {
            for (DataPoint bi : b) {
                double d;
                double tmpDist = this.distance(ai, bi);
                if (!(d > maxDiss)) continue;
                maxDiss = tmpDist;
            }
        }
        return maxDiss;
    }

    @Override
    public double dissimilarity(Set<Integer> a, Set<Integer> b, double[][] distanceMatrix) {
        double maxDiss = Double.MIN_VALUE;
        for (int ai : a) {
            for (int bi : b) {
                if (!(CompleteLinkDissimilarity.getDistance(distanceMatrix, ai, bi) > maxDiss)) continue;
                maxDiss = CompleteLinkDissimilarity.getDistance(distanceMatrix, ai, bi);
            }
        }
        return maxDiss;
    }

    @Override
    public double dissimilarity(int i, int ni, int j, int nj, double[][] distanceMatrix) {
        return CompleteLinkDissimilarity.getDistance(distanceMatrix, i, j);
    }

    @Override
    public double dissimilarity(int i, int ni, int j, int nj, int k, int nk, double[][] distanceMatrix) {
        return Math.max(CompleteLinkDissimilarity.getDistance(distanceMatrix, i, k), CompleteLinkDissimilarity.getDistance(distanceMatrix, j, k));
    }
}

