/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.dissimilarity;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jsat.classifiers.DataPoint;
import jsat.clustering.dissimilarity.DistanceMetricDissimilarity;
import jsat.clustering.dissimilarity.UpdatableClusterDissimilarity;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;

public class AverageLinkDissimilarity
extends DistanceMetricDissimilarity
implements UpdatableClusterDissimilarity {
    public AverageLinkDissimilarity() {
        this(new EuclideanDistance());
    }

    public AverageLinkDissimilarity(DistanceMetric dm) {
        super(dm);
    }

    @Override
    public AverageLinkDissimilarity clone() {
        return new AverageLinkDissimilarity(this.dm.clone());
    }

    @Override
    public double dissimilarity(List<DataPoint> a, List<DataPoint> b) {
        double disSum = 0.0;
        int allSize = a.size() + b.size();
        ArrayList<DataPoint> allPoints = new ArrayList<DataPoint>(allSize);
        allPoints.addAll(a);
        allPoints.addAll(b);
        for (int i = 0; i < allPoints.size(); ++i) {
            for (int j = i + 1; j < allPoints.size(); ++j) {
                disSum += this.distance((DataPoint)allPoints.get(i), (DataPoint)allPoints.get(j));
            }
        }
        return disSum / (double)(allSize * (allSize - 1));
    }

    @Override
    public double dissimilarity(Set<Integer> a, Set<Integer> b, double[][] distanceMatrix) {
        double disSum = 0.0;
        int allSize = a.size() + b.size();
        int[] allPoints = new int[allSize];
        int z = 0;
        for (int val : a) {
            allPoints[z++] = val;
        }
        for (int val : b) {
            allPoints[z++] = val;
        }
        for (int i = 0; i < allPoints.length; ++i) {
            for (int j = i + 1; j < allPoints.length; ++j) {
                disSum += AverageLinkDissimilarity.getDistance(distanceMatrix, allPoints[i], allPoints[j]);
            }
        }
        return disSum / (double)(allSize * (allSize - 1));
    }

    @Override
    public double dissimilarity(int i, int ni, int j, int nj, double[][] distanceMatrix) {
        return AverageLinkDissimilarity.getDistance(distanceMatrix, i, j);
    }

    @Override
    public double dissimilarity(int i, int ni, int j, int nj, int k, int nk, double[][] distanceMatrix) {
        double ai = (double)ni / (double)(ni + nj);
        double aj = (double)nj / (double)(ni + nj);
        return ai * AverageLinkDissimilarity.getDistance(distanceMatrix, i, k) + aj * AverageLinkDissimilarity.getDistance(distanceMatrix, j, k);
    }
}

