/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.trees;

import java.io.Serializable;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.DataPoint;

public abstract class TreeNodeVisitor
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4026847401940409114L;

    public abstract int childrenCount();

    public abstract boolean isLeaf();

    public abstract TreeNodeVisitor getChild(int var1);

    public abstract void disablePath(int var1);

    public void setPath(int child, TreeNodeVisitor node) {
        throw new UnsupportedOperationException("setPath is an optional operation.");
    }

    public abstract boolean isPathDisabled(int var1);

    public CategoricalResults localClassify(DataPoint dp) {
        throw new UnsupportedOperationException("This tree does not support classification");
    }

    public abstract int getPath(DataPoint var1);

    public CategoricalResults classify(DataPoint dp) {
        int path;
        TreeNodeVisitor node = this;
        while (!node.isLeaf() && !node.isPathDisabled(path = node.getPath(dp))) {
            node = node.getChild(path);
        }
        return node.localClassify(dp);
    }

    public double localRegress(DataPoint dp) {
        throw new UnsupportedOperationException("This tree does not support classification");
    }

    public double regress(DataPoint dp) {
        int path;
        TreeNodeVisitor node = this;
        while (!node.isLeaf() && !node.isPathDisabled(path = node.getPath(dp))) {
            node = node.getChild(path);
        }
        return node.localRegress(dp);
    }

    public abstract TreeNodeVisitor clone();
}

